/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.optimization;

import java.util.HashSet;
import java.util.Set;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.SideEffectVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.ArrayLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BooleanConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NullLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NumericConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.PropertyAccess;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.TernaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperation;

public class VariableFinder
extends SideEffectVisitor {
    private final Set<String> variables;

    public VariableFinder(Set<String> variables) {
        this.variables = variables;
    }

    private void traverse(ExpressionNode node) {
        if (node != null) {
            node.accept(this);
        }
    }

    public static Set<String> findVariables(ExpressionNode node) {
        HashSet<String> result = new HashSet<String>();
        VariableFinder finder = new VariableFinder(result);
        finder.traverse(node);
        return result;
    }

    @Override
    public void visit(PropertyAccess propertyAccess) {
        this.traverse(propertyAccess.getTarget());
        this.traverse(propertyAccess.getProperty());
    }

    @Override
    public void visit(Identifier identifier) {
        this.variables.add(identifier.getName());
    }

    @Override
    public void visit(StringConstant text) {
    }

    @Override
    public void visit(BinaryOperation binaryOperation) {
        this.traverse(binaryOperation.getLeftOperand());
        this.traverse(binaryOperation.getRightOperand());
    }

    @Override
    public void visit(BooleanConstant booleanConstant) {
    }

    @Override
    public void visit(NumericConstant numericConstant) {
    }

    @Override
    public void visit(UnaryOperation unaryOperation) {
        this.traverse(unaryOperation.getTarget());
    }

    @Override
    public void visit(TernaryOperator ternaryOperator) {
        this.traverse(ternaryOperator.getCondition());
        this.traverse(ternaryOperator.getThenBranch());
        this.traverse(ternaryOperator.getElseBranch());
    }

    @Override
    public void visit(RuntimeCall runtimeCall) {
        for (ExpressionNode node : runtimeCall.getArguments()) {
            this.traverse(node);
        }
    }

    @Override
    public void visit(MapLiteral mapLiteral) {
        for (ExpressionNode value : mapLiteral.getMap().values()) {
            this.traverse(value);
        }
    }

    @Override
    public void visit(ArrayLiteral arrayLiteral) {
        for (ExpressionNode item : arrayLiteral.getItems()) {
            this.traverse(item);
        }
    }

    @Override
    public void visit(NullLiteral nullLiteral) {
    }
}

