/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;

public class ReferenceParser {
    public static Value parse(Session session, String value, boolean weak) throws RepositoryException {
        Node n = ReferenceParser.parse(session, value);
        if (n == null) {
            return null;
        }
        return ReferenceParser.createReferenceValue(n, session.getValueFactory(), weak);
    }

    public static Value[] parse(Session session, String[] values, boolean weak) throws RepositoryException {
        Value[] ret = new Value[values.length];
        for (int i = 0; i < values.length; ++i) {
            Node n = ReferenceParser.parse(session, values[i]);
            if (n == null) {
                return null;
            }
            ret[i] = ReferenceParser.createReferenceValue(n, session.getValueFactory(), weak);
        }
        return ret;
    }

    private static Value createReferenceValue(Node node, ValueFactory factory, boolean weak) throws RepositoryException {
        if (weak) {
            return factory.createValue(node, true);
        }
        return factory.createValue(node);
    }

    private static Node parse(Session session, String value) throws RepositoryException {
        try {
            if (session.itemExists(value)) {
                return (Node)session.getItem(value);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        try {
            return session.getNodeByIdentifier(value);
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }
}

