/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.AuthorizableTypeException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.visitor.FilteringItemVisitor;
import org.apache.jackrabbit.oak.spi.security.principal.SystemUserPrincipal;
import org.apache.sling.testing.mock.jcr.MockGroup;
import org.apache.sling.testing.mock.jcr.MockUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockUserManager
implements UserManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Session session = null;
    protected Map<String, Authorizable> authorizables = new HashMap<String, Authorizable>();
    private boolean autoSave;

    @Deprecated
    public MockUserManager() {
        throw new UnsupportedOperationException();
    }

    public MockUserManager(Session session) {
        this.session = session;
    }

    void loadAlreadyExistingAuthorizables() {
        try {
            Node rootNode = this.session.getRootNode();
            if (rootNode.hasNode("home")) {
                FilteringItemVisitor visitor = new FilteringItemVisitor(){

                    protected void entering(Node node, int level) throws RepositoryException {
                        if (node.isNodeType("rep:User")) {
                            String userID = node.getProperty("rep:authorizableId").getString();
                            MockUserManager.this.authorizables.computeIfAbsent(userID, id -> new MockUser((String)id, null, node, MockUserManager.this));
                        } else if (node.isNodeType("rep:SystemUser")) {
                            String userID = node.getProperty("rep:authorizableId").getString();
                            SystemUserPrincipal p = () -> userID;
                            MockUserManager.this.authorizables.computeIfAbsent(userID, id -> new MockUser((String)id, (Principal)p, node, MockUserManager.this));
                        } else if (node.isNodeType("rep:Group")) {
                            String userID = node.getProperty("rep:authorizableId").getString();
                            MockUserManager.this.authorizables.computeIfAbsent(userID, id -> new MockGroup((String)id, null, node, MockUserManager.this));
                        }
                    }

                    protected void entering(Property property, int level) throws RepositoryException {
                    }

                    protected void leaving(Property property, int level) throws RepositoryException {
                    }

                    protected void leaving(Node node, int level) throws RepositoryException {
                    }
                };
                visitor.setWalkProperties(false);
                rootNode.getNode("home").accept((ItemVisitor)visitor);
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Failed to load already existing authorizables", (Throwable)e);
        }
    }

    boolean removeAuthorizable(Authorizable a) throws RepositoryException {
        String path;
        boolean removed = this.authorizables.remove(a.getID(), a);
        if (removed && this.session.nodeExists(path = a.getPath())) {
            this.session.getNode(path).remove();
        }
        return removed;
    }

    Set<Authorizable> all(int searchType) throws RepositoryException {
        return this.authorizables.values().stream().filter(a -> {
            boolean match = 3 == searchType ? true : (2 == searchType ? a.isGroup() : (1 == searchType ? !a.isGroup() : false));
            return match;
        }).collect(Collectors.toSet());
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void autoSave(boolean autoSave) throws RepositoryException {
        this.autoSave = autoSave;
    }

    @NotNull
    public Group createGroup(@NotNull String groupID) throws RepositoryException {
        return this.maybeCreateGroup(groupID, null, null);
    }

    @NotNull
    public Group createGroup(@NotNull Principal principal) throws RepositoryException {
        return this.maybeCreateGroup(null, principal, null);
    }

    @NotNull
    public Group createGroup(@NotNull Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        return this.maybeCreateGroup(null, principal, intermediatePath);
    }

    @NotNull
    public Group createGroup(@NotNull String groupID, @NotNull Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        return this.maybeCreateGroup(groupID, principal, intermediatePath);
    }

    @NotNull
    private Group maybeCreateGroup(@Nullable String groupID, @Nullable Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        if (this.authorizables.containsKey(groupID)) {
            throw new AuthorizableExistsException("Group already exists");
        }
        String principalName = this.toPrincipalName(groupID, principal);
        if (intermediatePath == null) {
            intermediatePath = "/home/groups";
        }
        Node node = this.ensureAuthorizablePathExists(intermediatePath, principalName, "rep:Group");
        return (Group)this.authorizables.computeIfAbsent(groupID, id -> new MockGroup((String)id, principal, node, this));
    }

    @Nullable
    protected String toPrincipalName(@Nullable String id, @Nullable Principal principal) {
        String principalName = id;
        if (principalName == null && principal != null) {
            principalName = principal.getName();
        }
        return principalName;
    }

    @Deprecated(forRemoval=true, since="1.4.0")
    protected Node ensureAuthorizablePathExists(@Nullable String intermediatePath, @NotNull String principalName, boolean isGroup) throws RepositoryException {
        if (intermediatePath == null) {
            intermediatePath = isGroup ? "/home/groups" : "/home/users";
        }
        String authorizableType = isGroup ? "rep:Group" : "rep:User";
        return this.ensureAuthorizablePathExists(intermediatePath, principalName, authorizableType);
    }

    protected Node ensureAuthorizablePathExists(@NotNull String intermediatePath, @NotNull String principalName, @NotNull String authorizableNodeType) throws RepositoryException {
        String[] segments = intermediatePath.split("/");
        Node node = this.session.getRootNode();
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            node = node.hasNode(segment) ? node.getNode(segment) : node.addNode(segment, "rep:AuthorizableFolder");
        }
        if (!node.hasNode(principalName)) {
            node = node.addNode(principalName, authorizableNodeType);
            node.setProperty("rep:principalName", principalName);
            node.setProperty("rep:authorizableId", principalName);
        } else {
            node = node.getNode(principalName);
        }
        return node;
    }

    @NotNull
    public User createSystemUser(@NotNull String userID, @Nullable String intermediatePath) throws RepositoryException {
        SystemUserPrincipal p = () -> userID;
        return this.maybeCreateUser(userID, null, (Principal)p, intermediatePath);
    }

    @NotNull
    public User createUser(@NotNull String userID, @Nullable String password) throws RepositoryException {
        return this.maybeCreateUser(userID, password, null, null);
    }

    @NotNull
    public User createUser(@NotNull String userID, @Nullable String password, @NotNull Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        return this.maybeCreateUser(userID, password, principal, intermediatePath);
    }

    @NotNull
    private User maybeCreateUser(@Nullable String userID, @Nullable String password, @Nullable Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        String authorizableNodeType;
        if (this.authorizables.containsKey(userID)) {
            throw new AuthorizableExistsException("User already exists");
        }
        String principalName = this.toPrincipalName(userID, principal);
        boolean isSystemUser = principal instanceof SystemUserPrincipal;
        String string = authorizableNodeType = isSystemUser ? "rep:SystemUser" : "rep:User";
        if (intermediatePath == null) {
            intermediatePath = isSystemUser ? "/home/users/system" : "/home/users";
        }
        Node node = this.ensureAuthorizablePathExists(intermediatePath, principalName, authorizableNodeType);
        User user = (User)this.authorizables.computeIfAbsent(userID, id -> new MockUser((String)id, principal, node, this));
        if (password != null) {
            user.changePassword(password);
        }
        return user;
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull Query query) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull String relPath, @Nullable String value) throws RepositoryException {
        return this.findAuthorizables(relPath, value, 3);
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull String relPath, @Nullable String value, int searchType) throws RepositoryException {
        HashSet<Authorizable> matches = new HashSet<Authorizable>();
        block0: for (Authorizable authorizable : this.authorizables.values()) {
            Value[] property;
            if ((2 != searchType ? (1 != searchType ? 3 != searchType : authorizable.isGroup()) : !authorizable.isGroup()) || (property = authorizable.getProperty(relPath)) == null) continue;
            if (value == null) {
                matches.add(authorizable);
                continue;
            }
            for (Value value2 : property) {
                if (!value.equals(value2.getString())) continue;
                matches.add(authorizable);
                continue block0;
            }
        }
        return matches.iterator();
    }

    @Nullable
    public Authorizable getAuthorizable(@NotNull String id) throws RepositoryException {
        return this.authorizables.get(id);
    }

    @Nullable
    public Authorizable getAuthorizable(@NotNull Principal principal) throws RepositoryException {
        return this.authorizables.get(principal.getName());
    }

    @Nullable
    public <T extends Authorizable> T getAuthorizable(@NotNull String id, @NotNull Class<T> authorizableClass) throws RepositoryException {
        Authorizable a = null;
        Authorizable authorizable = this.authorizables.get(id);
        if (authorizable != null) {
            if (authorizableClass.isInstance(authorizable)) {
                a = (Authorizable)authorizableClass.cast(authorizable);
            } else {
                throw new AuthorizableTypeException("Not the expected authorizable class");
            }
        }
        return (T)a;
    }

    @Nullable
    public Authorizable getAuthorizableByPath(@NotNull String path) throws RepositoryException {
        return this.authorizables.values().stream().filter(a -> {
            try {
                return path.equals(a.getPath());
            }
            catch (RepositoryException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Failed to match authorizable path", (Throwable)e);
                }
                return false;
            }
        }).findFirst().orElse(null);
    }
}

