/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.xml.TextValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.util.Base64;
import org.apache.jackrabbit.value.ValueHelper;

class StringValue
implements TextValue {
    private final String value;
    private final NamePathResolver nsContext;
    private final ValueFactory valueFactory;

    protected StringValue(String value, NamePathResolver nsContext, ValueFactory valueFactory) {
        this.value = value;
        this.nsContext = nsContext;
        this.valueFactory = valueFactory;
    }

    public Value getValue(int type, NamePathResolver resolver) throws ValueFormatException, RepositoryException {
        if (type == 7 || type == 8) {
            InternalValue ival = InternalValue.create(ValueHelper.convert(this.value, type, this.valueFactory), this.nsContext);
            return ValueFormat.getJCRValue(ival, resolver, this.valueFactory);
        }
        return ValueHelper.deserialize(this.value, type, false, this.valueFactory);
    }

    public InternalValue getInternalValue(int targetType) throws ValueFormatException, RepositoryException {
        try {
            if (targetType == 2) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Base64.decode(this.value, (OutputStream)baos);
                return InternalValue.create(baos.toByteArray());
            }
            return InternalValue.create(ValueHelper.convert(this.value, targetType, this.valueFactory), this.nsContext);
        }
        catch (IOException e) {
            throw new RepositoryException("Error decoding Base64 content", (Throwable)e);
        }
    }

    public void dispose() {
    }
}

