/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import java.io.Closeable;
import java.util.Map;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.collect.Maps;

public class ObserverTracker
implements ServiceTrackerCustomizer {
    private final Map<ServiceReference, Closeable> subscriptions = Maps.newHashMap();
    private final Observable observable;
    private BundleContext bundleContext;
    private ServiceTracker observerTracker;

    public ObserverTracker(@NotNull Observable observable) {
        this.observable = Preconditions.checkNotNull(observable);
    }

    public void start(@NotNull BundleContext bundleContext) {
        Preconditions.checkState(this.bundleContext == null);
        this.bundleContext = Preconditions.checkNotNull(bundleContext);
        this.observerTracker = new ServiceTracker(bundleContext, Observer.class.getName(), (ServiceTrackerCustomizer)this);
        this.observerTracker.open();
    }

    public void stop() {
        Preconditions.checkState(this.bundleContext != null);
        this.observerTracker.close();
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.bundleContext.getService(reference);
        if (service instanceof Observer) {
            this.subscriptions.put(reference, this.observable.addObserver((Observer)service));
            return service;
        }
        this.bundleContext.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        Closeable subscription = this.subscriptions.remove(reference);
        if (subscription != null) {
            IOUtils.closeQuietly(subscription);
            this.bundleContext.ungetService(reference);
        }
    }
}

