/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.SimpleCommitContext;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.base.Preconditions;

public enum ResetCommitAttributeHook implements CommitHook
{
    INSTANCE;


    @Override
    @NotNull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        ResetCommitAttributeHook.resetAttributes(info);
        return after;
    }

    private static void resetAttributes(CommitInfo info) {
        SimpleCommitContext attrs = (SimpleCommitContext)info.getInfo().get("oak.commitAttributes");
        Preconditions.checkNotNull(attrs, "No commit attribute instance found in info map").clear();
    }
}

