/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.http;

import org.apache.sling.testing.tools.http.RequestBuilder;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.apache.sling.testing.tools.retry.RetryLoop;

public class RetryingContentChecker {
    private final RequestExecutor executor;
    private final RequestBuilder builder;
    private final String username;
    private final String password;

    public RetryingContentChecker(RequestExecutor executor, RequestBuilder builder) {
        this(executor, builder, null, null);
    }

    public RetryingContentChecker(RequestExecutor executor, RequestBuilder builder, String username, String password) {
        this.executor = executor;
        this.builder = builder;
        this.username = username != null ? username : "admin";
        this.password = password != null ? password : "admin";
    }

    public void check(final String path, final int expectedStatus, int timeoutSeconds, int intervalBetweenrequestsMsec) {
        RetryLoop.Condition c = new RetryLoop.Condition(){

            @Override
            public String getDescription() {
                return "Expecting " + path + " to return HTTP status " + expectedStatus;
            }

            @Override
            public boolean isTrue() throws Exception {
                RetryingContentChecker.this.executor.execute(RetryingContentChecker.this.builder.buildGetRequest(path, new String[0]).withCredentials(RetryingContentChecker.this.username, RetryingContentChecker.this.password)).assertStatus(expectedStatus);
                return RetryingContentChecker.this.assertMore(RetryingContentChecker.this.executor);
            }
        };
        new RetryLoop(c, timeoutSeconds, intervalBetweenrequestsMsec){

            @Override
            protected void onTimeout() {
                RetryingContentChecker.this.onTimeout();
            }
        };
    }

    protected boolean assertMore(RequestExecutor executor) throws Exception {
        return true;
    }

    protected void onTimeout() {
    }
}

