/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.junit;

import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.MDC;

public class TestDescriptionInterceptor
implements HttpRequestInterceptor {
    private static final String SLING_HEADER_PREFIX = "X-Sling-";

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        TestDescriptionInterceptor.addSlingHeaders(httpRequest);
    }

    private static void addSlingHeaders(HttpRequest m) {
        Map mdc = MDC.getCopyOfContextMap();
        if (mdc != null) {
            for (Map.Entry e : mdc.entrySet()) {
                Object key = e.getKey();
                if (!(key instanceof String) || !((String)key).startsWith(SLING_HEADER_PREFIX) || !(e.getValue() instanceof String)) continue;
                m.addHeader((String)key, (String)e.getValue());
            }
        }
    }
}

