/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.urlrewriter.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tuckey.web.filters.urlrewrite.Conf;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;
import org.tuckey.web.filters.urlrewrite.utils.Log;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.helpers.DefaultHandler;

@Component(label="Apache Sling URL Rewriter", description="multi-purpose service for altering HTTP requests/responses based on Tuckey's UrlRewriteFilter", immediate=true, metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Service
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"multi-purpose service for altering HTTP requests/responses based on Tuckey's UrlRewriteFilter"}), @Property(name="service.ranking", intValue={0}, propertyPrivate=false), @Property(name="sling.filter.scope", value={"REQUEST", "FORWARD"})})
public final class SlingUrlRewriteFilter
implements Filter {
    private UrlRewriter rewriter;
    public static final String DEFAULT_REWRITE_RULES = "<?xml version=\"1.0\" encoding=\"utf-8\"?><!DOCTYPE urlrewrite PUBLIC \"-//tuckey.org//DTD UrlRewrite 4.0//EN\" \"http://www.tuckey.org/res/dtds/urlrewrite4.0.dtd\"><urlrewrite/>";
    @Property(value={"<?xml version=\"1.0\" encoding=\"utf-8\"?><!DOCTYPE urlrewrite PUBLIC \"-//tuckey.org//DTD UrlRewrite 4.0//EN\" \"http://www.tuckey.org/res/dtds/urlrewrite4.0.dtd\"><urlrewrite/>"})
    public static final String REWRITE_RULES_PARAMETER = "org.apache.sling.urlrewriter.rewrite.rules";
    private final Logger logger = LoggerFactory.getLogger(SlingUrlRewriteFilter.class);

    public SlingUrlRewriteFilter() {
        Log.setLevel((String)"SLF4J");
    }

    @Activate
    private void activate(ComponentContext context) {
        this.logger.debug("activate");
        this.configure(context);
    }

    @Modified
    private void modified(ComponentContext context) {
        this.logger.debug("modified");
        this.configure(context);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivate");
        this.clearRewriter();
    }

    private void configure(ComponentContext context) {
        this.logger.info("configuring URL rewriter");
        Dictionary properties = context.getProperties();
        String rules = PropertiesUtil.toString(properties.get(REWRITE_RULES_PARAMETER), DEFAULT_REWRITE_RULES);
        Document document = this.createDocument(rules);
        if (document == null) {
            this.logger.error("creating rules document failed");
            return;
        }
        DocumentConf conf = new DocumentConf(document);
        conf.initialise();
        this.clearRewriter();
        if (!conf.isOk()) {
            this.logger.error("rewrite configuration is NOT ok");
            return;
        }
        this.logger.info("rewrite configuration is ok");
        this.rewriter = new UrlRewriter((Conf)conf);
        this.logger.info("rewrite engine is enabled: {}", (Object)conf.isEngineEnabled());
        if (conf.getRules() != null) {
            this.logger.info("number of rewrite rules: {}", (Object)conf.getRules().size());
        } else {
            this.logger.info("no rewrite rules");
        }
    }

    public void destroy() {
        this.logger.debug("destroy()");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.logger.debug("init({})", (Object)filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse;
        HttpServletRequest httpServletRequest;
        boolean handled;
        this.logger.debug("do filter");
        if (this.rewriter != null && servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse && (handled = this.rewriter.processRequest(httpServletRequest = (HttpServletRequest)servletRequest, httpServletResponse = (HttpServletResponse)servletResponse, filterChain))) {
            this.logger.debug("request handled by rewriter");
            return;
        }
        this.logger.debug("request NOT handled by rewriter");
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private Document createDocument(String rules) {
        if (StringUtils.isBlank((String)rules)) {
            this.logger.warn("given rules are blank");
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            String systemId = "";
            ConfHandler confHandler = new ConfHandler("");
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(confHandler);
            documentBuilder.setEntityResolver(confHandler);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(rules.getBytes("UTF-8"));
            Document document = documentBuilder.parse(inputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            return document;
        }
        catch (Exception e) {
            this.logger.error("error creating document from rules property", (Throwable)e);
            return null;
        }
    }

    private synchronized void clearRewriter() {
        if (this.rewriter != null) {
            this.rewriter.destroy();
            this.rewriter = null;
        }
    }

    public class ConfHandler
    extends DefaultHandler {
        protected final String systemId;

        public ConfHandler(String systemId) {
            this.systemId = systemId;
        }
    }

    public class DocumentConf
    extends Conf {
        public DocumentConf(Document rules) {
            this.processConfDoc(rules);
            this.initialise();
        }
    }
}

