/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport.deploy.method;

import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.sling.maven.bundlesupport.JsonSupport;
import org.apache.sling.maven.bundlesupport.deploy.DeployContext;
import org.apache.sling.maven.bundlesupport.deploy.DeployMethod;

public class FelixPostDeployMethod
implements DeployMethod {
    @Override
    public void deploy(URI targetURL, File file, String bundleSymbolicName, DeployContext context) throws IOException {
        URI postUrl = targetURL.resolve("install");
        context.getLog().debug((CharSequence)("Installing via POST to " + postUrl));
        HttpPost filePost = new HttpPost(postUrl);
        filePost.setHeader("referer", (Object)"about:blank");
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody("action", "install");
        builder.addTextBody("_noredir_", "_noredir_");
        builder.addTextBody("bundlestartlevel", context.getBundleStartLevel());
        if (context.isBundleStart()) {
            builder.addTextBody("bundlestart", "start");
        }
        if (context.isRefreshPackages()) {
            builder.addTextBody("refreshPackages", "true");
        }
        builder.addBinaryBody("bundlefile", file);
        filePost.setEntity(builder.build());
        String response = (String)context.getHttpClient().execute((ClassicHttpRequest)filePost, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
        if (!response.isEmpty()) {
            throw new IOException("Unexpected response received from " + postUrl + ". Maybe wrong endpoint? Must be empty but was: " + response);
        }
    }

    @Override
    public void undeploy(URI targetURL, String bundleSymbolicName, DeployContext context) throws IOException {
        URI postUrl = targetURL.resolve("bundles/" + bundleSymbolicName);
        context.getLog().debug((CharSequence)("Uninstalling via POST to " + postUrl));
        HttpPost post = new HttpPost(postUrl);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("action", "uninstall"));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        String response = (String)context.getHttpClient().execute((ClassicHttpRequest)post, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
        try {
            JsonObject jsonObject = JsonSupport.parseObject(response);
            jsonObject.getBoolean("fragment");
        }
        catch (JsonException | ClassCastException | NullPointerException e) {
            throw new IOException("Unexpected response received from " + postUrl + ". Maybe wrong endpoint? Must be valid JSON but was: " + response);
        }
        context.getLog().debug((CharSequence)("Received response from " + postUrl + ": " + response));
    }
}

