/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport.deploy.method;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.sling.maven.bundlesupport.deploy.DeployContext;
import org.apache.sling.maven.bundlesupport.deploy.DeployMethod;
import org.apache.sling.maven.bundlesupport.deploy.method.IntermediateUrisExtractor;
import org.apache.sling.maven.bundlesupport.deploy.method.ResponseCodeEnforcingResponseHandler;
import org.apache.sling.maven.bundlesupport.deploy.method.SlingPostDeployMethod;
import org.apache.sling.maven.bundlesupport.deploy.method.WebDavMkCol;

public class WebDavPutDeployMethod
implements DeployMethod {
    @Override
    public void deploy(URI targetURL, File file, String bundleSymbolicName, DeployContext context) throws IOException {
        block2: {
            try {
                this.performPut(targetURL, file, context);
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() != 409) break block2;
                context.getLog().debug((CharSequence)"Bundle not installed due missing parent folders. Attempting to create parent structure.");
                this.createIntermediaryPaths(targetURL, context);
                context.getLog().debug((CharSequence)"Re-attempting bundle install after creating parent folders.");
                this.performPut(targetURL, file, context);
            }
        }
    }

    @Override
    public void undeploy(URI targetURL, String bundleName, DeployContext context) throws IOException {
        HttpDelete delete = new HttpDelete(SlingPostDeployMethod.getURLWithFilename(targetURL, bundleName));
        Integer status = (Integer)context.getHttpClient().execute((ClassicHttpRequest)delete, (HttpClientResponseHandler)new ResponseCodeEnforcingResponseHandler(204));
        context.getLog().debug((CharSequence)("Received status code " + status));
    }

    private void performPut(URI targetURL, File file, DeployContext context) throws IOException {
        HttpPut filePut = new HttpPut(SlingPostDeployMethod.getURLWithFilename(targetURL, file.getName()));
        filePut.setEntity((HttpEntity)new FileEntity(file, ContentType.create((String)context.getMimeType())));
        Integer status = (Integer)context.getHttpClient().execute((ClassicHttpRequest)filePut, (HttpClientResponseHandler)new ResponseCodeEnforcingResponseHandler(204, 201));
        context.getLog().debug((CharSequence)("Received status code " + status));
    }

    private void performHead(URI uri, DeployContext context) throws IOException {
        HttpHead head = new HttpHead(uri);
        context.getHttpClient().execute((ClassicHttpRequest)head, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
    }

    private void performMkCol(URI uri, DeployContext context) throws IOException {
        WebDavMkCol mkCol = new WebDavMkCol(uri);
        String response = (String)context.getHttpClient().execute((ClassicHttpRequest)mkCol, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
        context.getLog().info((CharSequence)("Received response: " + response));
    }

    private void createIntermediaryPaths(URI targetURL, DeployContext context) throws IOException {
        List<URI> intermediateUris = IntermediateUrisExtractor.extractIntermediateUris(targetURL);
        URI existingIntermediateUri = null;
        for (URI intermediateUri : intermediateUris) {
            try {
                try {
                    this.performHead(intermediateUri, context);
                    existingIntermediateUri = intermediateUri;
                    break;
                }
                catch (HttpResponseException e) {
                    if (e.getStatusCode() == 403) {
                        existingIntermediateUri = intermediateUri;
                        break;
                    }
                    if (e.getStatusCode() == 404) continue;
                    throw e;
                }
            }
            catch (IOException e) {
                throw new IOException("Failed getting intermediate path at " + intermediateUri + ". Reason: " + e.getMessage(), e);
            }
        }
        if (existingIntermediateUri == null) {
            throw new IOException("Could not find any intermediate path up until the root of " + targetURL + ".");
        }
        int startOfInexistingIntermediateUri = intermediateUris.indexOf(existingIntermediateUri);
        if (startOfInexistingIntermediateUri == -1) {
            throw new IllegalStateException("Could not find intermediate uri " + existingIntermediateUri + " in the list");
        }
        for (int index = startOfInexistingIntermediateUri - 1; index >= 0; --index) {
            URI intermediateUri = intermediateUris.get(index);
            try {
                this.performMkCol(intermediateUri, context);
                context.getLog().debug((CharSequence)("Intermediate path at " + intermediateUri + " successfully created"));
                continue;
            }
            catch (IOException e) {
                throw new IOException("Failed creating intermediate path at '" + intermediateUri + "'. Reason: " + e.getMessage());
            }
        }
    }
}

