/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.storm.sql.runtime;

import java.io.Serializable;

/**
 * Describe each column of the field.
 */
public class FieldInfo implements Serializable {
    private final String name;
    private final Class<?> type;
    private final boolean isPrimary;

    /**
     * FieldInfo Constructor.
     * @param name field name
     * @param type filed type
     * @param isPrimary primary or not
     */
    public FieldInfo(String name, Class<?> type, boolean isPrimary) {
        this.name = name;
        this.type = type;
        this.isPrimary = isPrimary;
    }

    public String name() {
        return name;
    }

    public Class<?> type() {
        return type;
    }

    public boolean isPrimary() {
        return isPrimary;
    }
}
