/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.sitemesh;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.util.OutputConverter;
import com.opensymphony.xwork2.ActionContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.listener.StrutsListener;
import org.apache.struts2.views.velocity.VelocityManager;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.VelocityViewServlet;

public class VelocityDecoratorServlet
extends VelocityViewServlet {
    private static final Logger LOG = LogManager.getLogger(VelocityDecoratorServlet.class);
    private static final long serialVersionUID = -6731485159371716918L;
    protected VelocityManager velocityManager;
    protected String defaultContentType;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Dispatcher dispatcher = (Dispatcher)this.getServletContext().getAttribute("com.opensymphony.xwork2.dispatcher.ServletDispatcher");
        if (dispatcher == null) {
            throw new IllegalStateException("Unable to find the Dispatcher in the Servlet Context. Is '" + StrutsListener.class.getName() + "' missing in web.xml?");
        }
        this.velocityManager = (VelocityManager)dispatcher.getContainer().getInstance(VelocityManager.class);
        this.velocityManager.init(config.getServletContext());
        this.getVelocityView().setVelocityEngine(this.velocityManager.getVelocityEngine());
        this.defaultContentType = this.getVelocityProperty("default.contentType", "text/html");
        String encoding = this.getVelocityProperty("output.encoding", "ISO-8859-1");
        if (!"ISO-8859-1".equalsIgnoreCase(encoding)) {
            int index = this.defaultContentType.lastIndexOf("charset");
            if (index < 0) {
                this.defaultContentType = this.defaultContentType + "; charset=" + encoding;
            } else {
                this.getVelocityView().getVelocityEngine().getLog().warn((Object)"VelocityViewServlet: Charset was already specified in the Content-Type property.  Output encoding property will be ignored.");
            }
        }
        this.getVelocityView().getVelocityEngine().getLog().info((Object)("VelocityViewServlet: Default content-type is: " + this.defaultContentType));
    }

    public Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context context) {
        String template;
        HTMLPage htmlPage = (HTMLPage)request.getAttribute("__sitemesh__page");
        context.put("base", (Object)request.getContextPath());
        context.put("req", (Object)request);
        context.put("res", (Object)response);
        if (htmlPage == null) {
            context.put("title", (Object)"Title?");
            context.put("body", (Object)"<p>Body?</p>");
            context.put("head", (Object)"<!-- head -->");
            template = request.getServletPath();
        } else {
            try {
                context.put("title", (Object)OutputConverter.convert((String)htmlPage.getTitle()));
                StringWriter buffer = new StringWriter();
                htmlPage.writeBody(OutputConverter.getWriter((Writer)buffer));
                context.put("body", (Object)buffer.toString());
                buffer = new StringWriter();
                htmlPage.writeHead(OutputConverter.getWriter((Writer)buffer));
                context.put("head", (Object)buffer.toString());
            }
            catch (IOException e) {
                LOG.error("IOException handle request template", (Throwable)e);
            }
            context.put("page", (Object)htmlPage);
            DecoratorMapper decoratorMapper = this.getDecoratorMapper();
            Decorator decorator = decoratorMapper.getDecorator(request, (Page)htmlPage);
            template = decorator.getPage();
        }
        return this.getTemplate(template);
    }

    private DecoratorMapper getDecoratorMapper() {
        Factory factory = Factory.getInstance((Config)new Config(this.getServletConfig()));
        return factory.getDecoratorMapper();
    }

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        Context context = (Context)request.getAttribute(".KEY_velocity.struts2.context");
        if (context == null) {
            ActionContext ctx = ServletActionContext.getActionContext((HttpServletRequest)request);
            context = this.velocityManager.createContext(ctx.getValueStack(), request, response);
        }
        return context;
    }

    protected void setContentType(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(this.defaultContentType);
    }
}

