/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.net.InetAddress;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.dispatchers.RequestURIBasedDispatcher;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.synapse.transport.nhttp.HttpCoreRequestResponseTransport;
import org.apache.synapse.transport.nhttp.util.NhttpUtil;
import org.apache.synapse.transport.nhttp.util.RESTUtil;
import org.apache.synapse.transport.passthru.HttpGetRequestProcessor;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.SourceResponse;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.util.SourceResponseFactory;

public class ServerWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(ServerWorker.class);
    private MessageContext msgContext = null;
    private SourceRequest request = null;
    private SourceConfiguration sourceConfiguration = null;
    private static final String SOAP_ACTION_HEADER = "SOAPAction";
    private HttpGetRequestProcessor httpGetRequestProcessor = null;
    private boolean isHttps = false;

    public ServerWorker(SourceRequest request, SourceConfiguration sourceConfiguration) {
        this.request = request;
        this.sourceConfiguration = sourceConfiguration;
        this.isHttps = sourceConfiguration.isSsl();
        this.msgContext = this.createMessageContext(request);
        this.httpGetRequestProcessor = sourceConfiguration.getHttpGetRequestProcessor();
        this.msgContext.setProperty("pass-through.Source-Request", (Object)request);
        this.msgContext.setProperty("PASS_THROUGH_SOURCE_CONFIGURATION", (Object)sourceConfiguration);
        this.msgContext.setProperty("pass-through.Source-Connection", (Object)request.getConnection());
    }

    @Override
    public void run() {
        HttpInetConnection conn;
        InetAddress localAddress;
        int pos;
        String uri;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting a new Server Worker instance");
        }
        ConfigurationContext cfgCtx = this.sourceConfiguration.getConfigurationContext();
        this.msgContext.setProperty("HTTP_METHOD", (Object)this.request.getMethod());
        String method = this.request.getRequest() != null ? this.request.getRequest().getRequestLine().getMethod().toUpperCase() : "";
        String oriUri = uri = this.request.getUri();
        if (uri.contains(cfgCtx.getServicePath())) {
            pos = (uri = uri.substring(uri.indexOf(cfgCtx.getServicePath()) + cfgCtx.getServicePath().length())).indexOf("/", 1);
            uri = pos > 0 ? uri.substring(pos) : ((pos = uri.indexOf("?")) != -1 ? uri.substring(pos) : "");
        } else {
            pos = uri.indexOf("://");
            if (pos != -1 && (pos = (uri = uri.substring(pos + 3)).indexOf("/")) != -1) {
                uri = uri.substring(pos + 1);
            }
        }
        String servicePrefix = oriUri.substring(0, oriUri.indexOf(uri));
        if (!servicePrefix.contains("://") && (localAddress = (conn = (HttpInetConnection)this.request.getConnection()).getLocalAddress()) != null) {
            servicePrefix = (this.sourceConfiguration.isSsl() ? "https://" : "http://") + localAddress.getHostAddress() + ":" + conn.getLocalPort() + servicePrefix;
        }
        this.msgContext.setProperty("SERVICE_PREFIX", (Object)servicePrefix);
        this.msgContext.setTo(new EndpointReference(uri));
        this.msgContext.setProperty("REST_URL_POSTFIX", (Object)uri);
        if (("GET".equals(method) || "DELETE".equals(method)) && this.httpGetRequestProcessor != null) {
            HttpResponse response = this.sourceConfiguration.getResponseFactory().newHttpResponse(this.request.getVersion(), 200, this.request.getConnection().getContext());
            BasicHttpEntity entity = new BasicHttpEntity();
            if (this.request.getVersion().greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                entity.setChunked(true);
            }
            response.setEntity((HttpEntity)entity);
            this.httpGetRequestProcessor.process(this.request.getRequest(), response, this.msgContext, this.request.getConnection(), true);
        }
        boolean restHandle = false;
        if (this.msgContext.getProperty("rest_get_delete_invoke") != null && ((Boolean)this.msgContext.getProperty("rest_get_delete_invoke")).booleanValue()) {
            this.msgContext.setProperty("HTTP_METHOD_OBJECT", (Object)method);
            this.msgContext.setServerSide(true);
            this.msgContext.setDoingREST(true);
            String contentTypeHeader = this.request.getHeaders().get("Content-Type");
            SOAPEnvelope soapEnvelope = this.handleRESTUrlPost(contentTypeHeader);
            this.processNonEntityEnclosingRESTHandler(soapEnvelope);
            restHandle = true;
        }
        SourceContext info = (SourceContext)this.request.getConnection().getContext().getAttribute("CONNECTION_INFORMATION");
        Object getHandled = this.msgContext.getProperty("GET_REQUEST_HANDLED");
        if (info != null && info.getState().equals((Object)ProtocolState.GET_REQUEST_COMPLETE) || Boolean.TRUE.equals(getHandled)) {
            return;
        }
        if (!restHandle) {
            if (this.request.isEntityEnclosing()) {
                this.processEntityEnclosingRequest();
            } else {
                this.processNonEntityEnclosingRESTHandler(null);
            }
        }
        this.sendAck();
    }

    private SOAPEnvelope handleRESTUrlPost(String contentTypeHdr) throws FactoryConfigurationError {
        String contentType;
        SOAPEnvelope soapEnvelope = null;
        String string = contentType = contentTypeHdr != null ? TransportUtils.getContentType((String)contentTypeHdr, (MessageContext)this.msgContext) : null;
        if (contentType == null || "".equals(contentType) || "application/x-www-form-urlencoded".equals(contentType)) {
            contentType = contentTypeHdr != null ? contentTypeHdr : "application/x-www-form-urlencoded";
            this.msgContext.setTo(new EndpointReference(this.request.getRequest().getRequestLine().getUri()));
            this.msgContext.setProperty("ContentType", (Object)contentType);
            String charSetEncoding = BuilderUtil.getCharSetEncoding((String)contentType);
            this.msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEncoding);
            try {
                RESTUtil.dispatchAndVerify(this.msgContext);
            }
            catch (AxisFault e1) {
                log.error((Object)"Error while building message for REST_URL request", (Throwable)e1);
            }
            RequestURIBasedDispatcher requestDispatcher = new RequestURIBasedDispatcher();
            try {
                AxisService axisService = requestDispatcher.findService(this.msgContext);
                if (axisService == null) {
                    String defaultSvcName = PassThroughConfiguration.getInstance().getStringProperty("nhttp.default.service", "__SynapseService");
                    axisService = this.msgContext.getConfigurationContext().getAxisConfiguration().getService(defaultSvcName);
                    this.msgContext.setAxisService(axisService);
                }
            }
            catch (AxisFault e) {
                this.handleException("Error processing " + this.request.getMethod() + " request for : " + this.request.getUri(), (Exception)((Object)e));
            }
            try {
                soapEnvelope = TransportUtils.createSOAPMessage((MessageContext)this.msgContext, null, (String)contentType);
            }
            catch (Exception e) {
                log.error((Object)"Error while building message for REST_URL request");
            }
            this.msgContext.setProperty("messageType", (Object)"application/xml");
        }
        return soapEnvelope;
    }

    private void sendAck() {
        String respWritten = "";
        if (this.msgContext.getOperationContext() != null) {
            respWritten = (String)this.msgContext.getOperationContext().getProperty("RESPONSE_WRITTEN");
        }
        if (this.msgContext.getProperty("FORCE_SOAP_FAULT") != null) {
            respWritten = "SKIP";
        }
        boolean respWillFollow = !"true".equals(respWritten) && !"SKIP".equals(respWritten);
        boolean ack = ((RequestResponseTransport)this.msgContext.getProperty("RequestResponseTransportControl")).getStatus() == RequestResponseTransport.RequestResponseTransportStatus.ACKED;
        boolean forced = this.msgContext.isPropertyTrue("FORCE_SC_ACCEPTED");
        boolean nioAck = this.msgContext.isPropertyTrue("NIO-ACK-Requested", false);
        if (respWillFollow || ack || forced || nioAck) {
            SourceResponse sourceResponse;
            NHttpServerConnection conn = this.request.getConnection();
            if (!nioAck) {
                this.msgContext.removeProperty("TRANSPORT_HEADERS");
                sourceResponse = SourceResponseFactory.create(this.msgContext, this.request, this.sourceConfiguration);
                sourceResponse.setStatus(202);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending ACK response with status " + this.msgContext.getProperty("HTTP_SC") + ", for MessageID : " + this.msgContext.getMessageID()));
                }
                sourceResponse = SourceResponseFactory.create(this.msgContext, this.request, this.sourceConfiguration);
                sourceResponse.setStatus(Integer.parseInt(this.msgContext.getProperty("HTTP_SC").toString()));
            }
            SourceContext.setResponse((NHttpConnection)conn, sourceResponse);
            ProtocolState state = SourceContext.getState((NHttpConnection)conn);
            if (state != null && state.compareTo(ProtocolState.REQUEST_DONE) <= 0) {
                conn.requestOutput();
            } else {
                SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
                this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
            }
        }
    }

    private void processNonEntityEnclosingRESTHandler(SOAPEnvelope soapEnvelope) {
        String soapAction = this.request.getHeaders().get(SOAP_ACTION_HEADER);
        if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        this.msgContext.setSoapAction(soapAction);
        this.msgContext.setTo(new EndpointReference(this.request.getUri()));
        this.msgContext.setServerSide(true);
        this.msgContext.setDoingREST(true);
        if (!this.request.isEntityEnclosing()) {
            this.msgContext.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
        }
        try {
            if (soapEnvelope == null) {
                this.msgContext.setEnvelope(OMAbstractFactory.getSOAP11Factory().getDefaultEnvelope());
            } else {
                this.msgContext.setEnvelope(soapEnvelope);
            }
            AxisEngine.receive((MessageContext)this.msgContext);
        }
        catch (AxisFault axisFault) {
            this.handleException("Error processing " + this.request.getMethod() + " request for : " + this.request.getUri(), (Exception)((Object)axisFault));
        }
    }

    private void processEntityEnclosingRequest() {
        try {
            SOAPEnvelope envelope;
            String contentTypeHeader = this.request.getHeaders().get("Content-Type");
            contentTypeHeader = contentTypeHeader != null ? contentTypeHeader : this.inferContentType();
            String charSetEncoding = null;
            String contentType = null;
            if (contentTypeHeader != null) {
                charSetEncoding = BuilderUtil.getCharSetEncoding((String)contentTypeHeader);
                contentType = TransportUtils.getContentType((String)contentTypeHeader, (MessageContext)this.msgContext);
            }
            if (charSetEncoding == null) {
                charSetEncoding = "UTF-8";
            }
            String method = this.request.getRequest() != null ? this.request.getRequest().getRequestLine().getMethod().toUpperCase() : "";
            this.msgContext.setTo(new EndpointReference(this.request.getUri()));
            this.msgContext.setProperty("HTTP_METHOD_OBJECT", (Object)method);
            this.msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEncoding);
            this.msgContext.setServerSide(true);
            this.msgContext.setProperty("ContentType", (Object)contentTypeHeader);
            this.msgContext.setProperty("messageType", (Object)contentType);
            if (contentTypeHeader == null || HTTPTransportUtils.isRESTRequest((String)contentTypeHeader) || this.isRest(contentTypeHeader)) {
                this.msgContext.setProperty("synapse.internal.rest.contentType", (Object)contentType);
                this.msgContext.setDoingREST(true);
                SOAPEnvelope soapEnvelope = this.handleRESTUrlPost(contentTypeHeader);
                this.msgContext.setProperty("pass-through.pipe", (Object)this.request.getPipe());
                this.processNonEntityEnclosingRESTHandler(soapEnvelope);
                return;
            }
            String soapAction = this.request.getHeaders().get(SOAP_ACTION_HEADER);
            int soapVersion = HTTPTransportUtils.initializeMessageContext((MessageContext)this.msgContext, (String)soapAction, (String)this.request.getUri(), (String)contentTypeHeader);
            if (soapVersion == 1) {
                SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
                envelope = fac.getDefaultEnvelope();
            } else {
                SOAPFactory fac = OMAbstractFactory.getSOAP12Factory();
                envelope = fac.getDefaultEnvelope();
            }
            this.msgContext.setEnvelope(envelope);
            this.msgContext.setProperty("pass-through.pipe", (Object)this.request.getPipe());
            AxisEngine.receive((MessageContext)this.msgContext);
        }
        catch (AxisFault axisFault) {
            this.handleException("Error processing " + this.request.getMethod() + " request for : " + this.request.getUri(), (Exception)((Object)axisFault));
        }
    }

    private boolean isRest(String contentType) {
        return contentType != null && !contentType.contains("text/xml") && !contentType.contains("application/soap+xml");
    }

    private MessageContext createMessageContext(SourceRequest request) {
        HttpInetConnection netConn;
        InetAddress remoteAddress;
        Map excessHeaders = request.getExcessHeaders();
        ConfigurationContext cfgCtx = this.sourceConfiguration.getConfigurationContext();
        MessageContext msgContext = new MessageContext();
        msgContext.setMessageID(UIDGenerator.generateURNString());
        msgContext.setProperty("ClientApiNonBlocking", (Object)Boolean.FALSE);
        msgContext.setConfigurationContext(cfgCtx);
        NHttpServerConnection conn = request.getConnection();
        if (this.isHttps) {
            msgContext.setTransportOut(cfgCtx.getAxisConfiguration().getTransportOut("https"));
            msgContext.setTransportIn(cfgCtx.getAxisConfiguration().getTransportIn("https"));
            msgContext.setIncomingTransportName("https");
            SSLIOSession session = (SSLIOSession)conn.getContext().getAttribute("http.session.ssl");
            msgContext.setProperty("ssl.client.auth.cert.X509", session.getAttribute("ssl.client.auth.cert.X509"));
        } else {
            msgContext.setTransportOut(cfgCtx.getAxisConfiguration().getTransportOut("http"));
            msgContext.setTransportIn(cfgCtx.getAxisConfiguration().getTransportIn("http"));
            msgContext.setIncomingTransportName("http");
        }
        msgContext.setProperty("OutTransportInfo", (Object)this);
        msgContext.setServerSide(true);
        msgContext.setProperty("TransportInURL", (Object)request.getUri());
        TreeMap<String, String> headers = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        Set<Map.Entry<String, String>> entries = request.getHeaders().entrySet();
        for (Map.Entry<String, String> entry : entries) {
            headers.put(entry.getKey(), entry.getValue());
        }
        msgContext.setProperty("TRANSPORT_HEADERS", headers);
        msgContext.setProperty("EXCESS_TRANSPORT_HEADERS", (Object)excessHeaders);
        if (headers.get("Content-Length") != null) {
            msgContext.setProperty("ORIGINAL_CONTENT_LENGTH", headers.get("Content-Length"));
        }
        if (conn instanceof HttpInetConnection && (remoteAddress = (netConn = (HttpInetConnection)conn).getRemoteAddress()) != null) {
            msgContext.setProperty("REMOTE_ADDR", (Object)remoteAddress.getHostAddress());
            msgContext.setProperty("REMOTE_HOST", (Object)NhttpUtil.getHostName(remoteAddress));
        }
        msgContext.setProperty("RequestResponseTransportControl", (Object)new HttpCoreRequestResponseTransport(msgContext));
        return msgContext;
    }

    private void handleException(String msg, Exception e) {
        if (e == null) {
            log.error((Object)msg);
        } else {
            log.error((Object)msg, (Throwable)e);
        }
        if (e == null) {
            e = new Exception(msg);
        }
        try {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)this.msgContext, (Throwable)e);
            this.msgContext.setProperty("FORCE_SOAP_FAULT", (Object)Boolean.TRUE);
            AxisEngine.sendFault((MessageContext)faultContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String inferContentType() {
        Parameter param = this.sourceConfiguration.getConfigurationContext().getAxisConfiguration().getParameter("DEFAULT_REQUEST_CONTENT_TYPE");
        if (param != null) {
            return param.getValue().toString();
        }
        return null;
    }

    MessageContext getRequestContext() {
        return this.msgContext;
    }
}

