/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.conn.logging;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionBufferStatus;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.synapse.transport.utils.conn.logging.Wire;

public class LoggingIOSession
implements IOSession {
    private static AtomicLong COUNT = new AtomicLong(0L);
    private final Log sessionLog;
    private final Wire wireLog;
    private final IOSession session;
    private final ByteChannel channel;
    private final String id;

    public LoggingIOSession(Log sessionLog, Log wireLog, IOSession session, String id) {
        if (session == null) {
            throw new IllegalArgumentException("I/O session must not be null");
        }
        this.session = session;
        this.channel = new LoggingByteChannel();
        this.id = id + "-" + COUNT.incrementAndGet();
        this.sessionLog = sessionLog;
        this.wireLog = new Wire(wireLog);
    }

    public int getStatus() {
        return this.session.getStatus();
    }

    public ByteChannel channel() {
        return this.channel;
    }

    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    public int getEventMask() {
        return this.session.getEventMask();
    }

    private static String formatOps(int ops) {
        StringBuilder buffer = new StringBuilder(6);
        buffer.append('[');
        if ((ops & 1) > 0) {
            buffer.append('r');
        }
        if ((ops & 4) > 0) {
            buffer.append('w');
        }
        if ((ops & 0x10) > 0) {
            buffer.append('a');
        }
        if ((ops & 8) > 0) {
            buffer.append('c');
        }
        buffer.append(']');
        return buffer.toString();
    }

    private String getPreamble() {
        String preamble = "I/O session " + this.id + " " + this.session;
        if (this.session instanceof SSLIOSession) {
            return "SSL " + preamble;
        }
        return preamble;
    }

    public void setEventMask(int ops) {
        if (this.sessionLog.isDebugEnabled()) {
            this.sessionLog.debug((Object)(this.getPreamble() + ": Set event mask " + LoggingIOSession.formatOps(ops)));
        }
        this.session.setEventMask(ops);
    }

    public void setEvent(int op) {
        if (this.sessionLog.isDebugEnabled()) {
            this.sessionLog.debug((Object)(this.getPreamble() + ": Set event " + LoggingIOSession.formatOps(op)));
        }
        this.session.setEvent(op);
    }

    public void clearEvent(int op) {
        if (this.sessionLog.isDebugEnabled()) {
            this.sessionLog.debug((Object)(this.getPreamble() + ": Clear event " + LoggingIOSession.formatOps(op)));
        }
        this.session.clearEvent(op);
    }

    public void close() {
        if (this.sessionLog.isDebugEnabled()) {
            this.sessionLog.debug((Object)(this.getPreamble() + ": Close"));
        }
        this.session.close();
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public void shutdown() {
        if (this.sessionLog.isDebugEnabled()) {
            this.sessionLog.debug((Object)(this.getPreamble() + ": Shutdown"));
        }
        this.session.shutdown();
    }

    public int getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    public void setSocketTimeout(int timeout) {
        if (this.sessionLog.isDebugEnabled()) {
            this.sessionLog.debug((Object)(this.getPreamble() + ": Set timeout " + timeout));
        }
        this.session.setSocketTimeout(timeout);
    }

    public void setBufferStatus(SessionBufferStatus status) {
        this.session.setBufferStatus(status);
    }

    public boolean hasBufferedInput() {
        return this.session.hasBufferedInput();
    }

    public boolean hasBufferedOutput() {
        return this.session.hasBufferedOutput();
    }

    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    public void setAttribute(String name, Object obj) {
        if (this.sessionLog.isDebugEnabled()) {
            this.sessionLog.debug((Object)(this.getPreamble() + ": Set attribute " + name));
        }
        this.session.setAttribute(name, obj);
    }

    public Object removeAttribute(String name) {
        if (this.sessionLog.isDebugEnabled()) {
            this.sessionLog.debug((Object)(this.getPreamble() + ": Remove attribute " + name));
        }
        return this.session.removeAttribute(name);
    }

    class LoggingByteChannel
    implements ByteChannel {
        LoggingByteChannel() {
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int bytesRead = LoggingIOSession.this.session.channel().read(dst);
            if (LoggingIOSession.this.sessionLog.isDebugEnabled()) {
                LoggingIOSession.this.sessionLog.debug((Object)(LoggingIOSession.this.getPreamble() + ": " + bytesRead + " bytes read"));
            }
            if (bytesRead > 0 && LoggingIOSession.this.wireLog.isEnabled()) {
                ByteBuffer b = dst.duplicate();
                int p = b.position();
                b.limit(p);
                b.position(p - bytesRead);
                LoggingIOSession.this.wireLog.input(b);
            }
            return bytesRead;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int byteWritten = LoggingIOSession.this.session.channel().write(src);
            if (LoggingIOSession.this.sessionLog.isDebugEnabled()) {
                LoggingIOSession.this.sessionLog.debug((Object)(LoggingIOSession.this.getPreamble() + ": " + byteWritten + " bytes written"));
            }
            if (byteWritten > 0 && LoggingIOSession.this.wireLog.isEnabled()) {
                ByteBuffer b = src.duplicate();
                int p = b.position();
                b.limit(p);
                b.position(p - byteWritten);
                LoggingIOSession.this.wireLog.output(b);
            }
            return byteWritten;
        }

        @Override
        public void close() throws IOException {
            if (LoggingIOSession.this.sessionLog.isDebugEnabled()) {
                LoggingIOSession.this.sessionLog.debug((Object)(LoggingIOSession.this.getPreamble() + ": Channel close"));
            }
            LoggingIOSession.this.session.channel().close();
        }

        @Override
        public boolean isOpen() {
            return LoggingIOSession.this.session.channel().isOpen();
        }
    }
}

