/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.HostFileNameParser;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class FtpFileNameParser
extends HostFileNameParser {
    private static final FtpFileNameParser INSTANCE = new FtpFileNameParser();
    private static final int PORT = 21;

    public FtpFileNameParser() {
        super(21);
    }

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        HostFileNameParser.Authority auth = this.extractToPath(filename, name);
        String queryString = UriParser.extractQueryString((StringBuilder)name);
        if (queryString == null && base instanceof URLFileName) {
            queryString = ((URLFileName)base).getQueryString();
        }
        UriParser.canonicalizePath((StringBuilder)name, (int)0, (int)name.length(), (FileNameParser)this);
        UriParser.fixSeparators((StringBuilder)name);
        FileType fileType = UriParser.normalisePath((StringBuilder)name);
        String path = name.toString();
        return new URLFileName(auth.getScheme(), auth.getHostName(), auth.getPort(), this.getDefaultPort(), auth.getUserName(), auth.getPassword(), path, fileType, queryString);
    }
}

