/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.validator;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.signature.X509CRL;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.signature.X509IssuerSerial;
import org.opensaml.xml.signature.X509SKI;
import org.opensaml.xml.signature.X509SubjectName;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509DataSchemaValidator
implements Validator<X509Data> {
    private static final Set<QName> VALID_DS_CHILD_NAMES = new HashSet<QName>(10);

    @Override
    public void validate(X509Data xmlObject) throws ValidationException {
        this.validateChildrenPresence(xmlObject);
        this.validateChildrenNamespaces(xmlObject);
    }

    protected static Set<QName> getValidDSChildNames() {
        return VALID_DS_CHILD_NAMES;
    }

    protected void validateChildrenPresence(X509Data xmlObject) throws ValidationException {
        if (xmlObject.getXMLObjects().isEmpty()) {
            throw new ValidationException("No children were present in the X509Data object");
        }
    }

    protected void validateChildrenNamespaces(X509Data xmlObject) throws ValidationException {
        for (XMLObject child : xmlObject.getXMLObjects()) {
            QName childName = child.getElementQName();
            if (X509DataSchemaValidator.getValidDSChildNames().contains(childName) || !"http://www.w3.org/2000/09/xmldsig#".equals(childName.getNamespaceURI())) continue;
            throw new ValidationException("X509Data contains an illegal child extension element: " + childName);
        }
    }

    static {
        VALID_DS_CHILD_NAMES.add(X509IssuerSerial.DEFAULT_ELEMENT_NAME);
        VALID_DS_CHILD_NAMES.add(X509SKI.DEFAULT_ELEMENT_NAME);
        VALID_DS_CHILD_NAMES.add(X509SubjectName.DEFAULT_ELEMENT_NAME);
        VALID_DS_CHILD_NAMES.add(X509Certificate.DEFAULT_ELEMENT_NAME);
        VALID_DS_CHILD_NAMES.add(X509CRL.DEFAULT_ELEMENT_NAME);
    }
}

