/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource.factory;

import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.DataSourceInformationRepository;
import org.apache.synapse.commons.datasource.DataSourceInformationRepositoryListener;
import org.apache.synapse.commons.datasource.DataSourceRepositoryManager;
import org.apache.synapse.commons.datasource.InMemoryDataSourceRepository;
import org.apache.synapse.commons.datasource.JNDIBasedDataSourceRepository;
import org.apache.synapse.commons.datasource.factory.DataSourceInformationListFactory;

public class DataSourceInformationRepositoryFactory {
    private static final Log log = LogFactory.getLog(DataSourceInformationRepositoryFactory.class);

    public static DataSourceInformationRepository createDataSourceInformationRepository(Properties properties) {
        return DataSourceInformationRepositoryFactory.createDataSourceInformationRepository(new DataSourceRepositoryManager(new InMemoryDataSourceRepository(), new JNDIBasedDataSourceRepository()), properties);
    }

    public static DataSourceInformationRepository createDataSourceInformationRepository(DataSourceInformationRepositoryListener listener, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating a new DataSourceInformationRepository");
        }
        DataSourceInformationRepository datasourceInformationRepository = new DataSourceInformationRepository();
        datasourceInformationRepository.setRepositoryListener(listener);
        DataSourceInformationRepositoryFactory.setupDataSourceInformationRepository(datasourceInformationRepository, properties);
        return datasourceInformationRepository;
    }

    public static void setupDataSourceInformationRepository(DataSourceInformationRepository datasourceInformationRepository, Properties properties) {
        if (properties != null) {
            datasourceInformationRepository.configure(properties);
        }
        List<DataSourceInformation> sourceInformationList = DataSourceInformationListFactory.createDataSourceInformationList(properties);
        for (DataSourceInformation information : sourceInformationList) {
            if (information == null) continue;
            datasourceInformationRepository.addDataSourceInformation(information);
        }
    }
}

