/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.template.InvokeMediator;

public class InvokeMediatorFactory
extends AbstractMediatorFactory {
    private static final QName INVOKE_Q = new QName("http://ws.apache.org/ns/synapse", "call-template");
    public static final QName WITH_PARAM_Q = new QName("http://ws.apache.org/ns/synapse", "with-param");
    InvokeMediator invoker;

    @Override
    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        this.invoker = new InvokeMediator();
        OMAttribute targetTemplateAttr = elem.getAttribute(ATT_TARGET);
        if (targetTemplateAttr == null) {
            String msg = "EIP Invoke mediator should have a target template specified.";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        this.invoker.setTargetTemplate(targetTemplateAttr.getAttributeValue());
        this.buildParameters(elem);
        return this.invoker;
    }

    private void buildParameters(OMElement elem) {
        Iterator subElements = elem.getChildElements();
        while (subElements.hasNext()) {
            OMAttribute paramNameAttr;
            OMElement child = (OMElement)subElements.next();
            if (!child.getQName().equals(WITH_PARAM_Q) || (paramNameAttr = child.getAttribute(ATT_NAME)) == null) continue;
            Value paramValue = new ValueFactory().createValue("value", child);
            this.invoker.addExpressionForParamName(paramNameAttr.getAttributeValue(), paramValue);
        }
    }

    @Override
    public QName getTagQName() {
        return INVOKE_Q;
    }
}

