/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.mediators.store.MessageStoreMediator;

public class MessageStoreMediatorSerializer
extends AbstractMediatorSerializer {
    private static final String ATT_MESSAGE_STORE = "messageStore";
    private static final String ATT_SEQUENCE = "sequence";

    @Override
    protected OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof MessageStoreMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        MessageStoreMediator messageStoreMediator = (MessageStoreMediator)m;
        String messageStoreName = messageStoreMediator.getMessageStoreName();
        OMElement storeElem = fac.createOMElement("store", synNS);
        String name = messageStoreMediator.getName();
        if (name != null) {
            OMAttribute nameAtt = fac.createOMAttribute("name", nullNS, name);
            storeElem.addAttribute(nameAtt);
        }
        if (messageStoreName != null) {
            OMAttribute msName = fac.createOMAttribute(ATT_MESSAGE_STORE, nullNS, messageStoreName);
            storeElem.addAttribute(msName);
        } else {
            this.handleException("Can't serialize MessageStore Mediator message store is null ");
        }
        String sequence = messageStoreMediator.getOnStoreSequence();
        if (sequence != null) {
            OMAttribute sequenceAtt = fac.createOMAttribute(ATT_SEQUENCE, nullNS, sequence);
            storeElem.addAttribute(sequenceAtt);
        }
        return storeElem;
    }

    @Override
    public String getMediatorClassName() {
        return MessageStoreMediator.class.getName();
    }
}

