/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.JavaUtils;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.xpath.SynapseXPath;

public class PropertyMediator
extends AbstractMediator {
    private String name = null;
    private Object value = null;
    private String type = null;
    private OMElement valueElement = null;
    private SynapseXPath expression = null;
    private String scope = null;
    public static final int ACTION_SET = 0;
    public static final int ACTION_REMOVE = 1;
    private int action = 0;
    private Pattern pattern;
    private int group = 0;

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Property mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        if (this.action == 0) {
            Object resultValue = this.getResultValue(synCtx);
            if (resultValue instanceof String && this.pattern != null) {
                resultValue = this.getMatchedValue((String)resultValue, synLog);
            }
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Setting property : " + this.name + " at scope : " + (this.scope == null ? "default" : this.scope) + " to : " + resultValue + " (i.e. " + (this.value != null ? "constant : " + this.value : "result of expression : " + (Object)((Object)this.expression)) + ")");
            }
            if (this.scope == null || "default".equals(this.scope)) {
                synCtx.setProperty(this.name, resultValue);
            } else if ("axis2".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.setProperty(this.name, resultValue);
            } else if ("axis2-client".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.getOptions().setProperty(this.name, resultValue);
            } else if ("transport".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                HashMap<String, Object> headersMap;
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
                if (headers != null && headers instanceof Map) {
                    headersMap = (HashMap<String, Object>)headers;
                    headersMap.put(this.name, resultValue);
                }
                if (headers == null) {
                    headersMap = new HashMap<String, Object>();
                    headersMap.put(this.name, resultValue);
                    axis2MessageCtx.setProperty("TRANSPORT_HEADERS", headersMap);
                }
            }
        } else {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Removing property : " + this.name + " (scope:" + (this.scope == null ? "default" : this.scope) + ")");
            }
            if (this.scope == null || "default".equals(this.scope)) {
                Set pros = synCtx.getPropertyKeySet();
                if (pros != null) {
                    pros.remove(this.name);
                }
            } else if (("axis2".equals(this.scope) || "axis2-client".equals(this.scope)) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.removeProperty(this.name);
            } else if ("transport".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
                if (headers != null && headers instanceof Map) {
                    Map headersMap = (Map)headers;
                    headersMap.remove(this.name);
                } else {
                    synLog.traceOrDebug("No transport headers found for the message");
                }
            }
        }
        synLog.traceOrDebug("End : Property mediator");
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.setValue(value, null);
    }

    public void setValue(String value, String type) {
        this.type = type;
        this.value = this.convertValue(value, type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public OMElement getValueElement() {
        return this.valueElement;
    }

    public void setValueElement(OMElement valueElement) {
        this.valueElement = valueElement;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public void setExpression(SynapseXPath expression) {
        this.setExpression(expression, null);
    }

    public void setExpression(SynapseXPath expression, String type) {
        this.expression = expression;
        this.type = type;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    private Object getResultValue(MessageContext synCtx) {
        if (this.value != null) {
            return this.value;
        }
        if (this.valueElement != null) {
            return this.valueElement.cloneOMElement();
        }
        return this.convertValue(this.expression.stringValueOf(synCtx), this.type);
    }

    private Object convertValue(String value, String type) {
        if (type == null) {
            return value;
        }
        try {
            XMLConfigConstants.DATA_TYPES dataType = XMLConfigConstants.DATA_TYPES.valueOf(type);
            switch (dataType) {
                case BOOLEAN: {
                    return JavaUtils.isTrueExplicitly((String)value);
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case INTEGER: {
                    return Integer.parseInt(value);
                }
                case LONG: {
                    return Long.parseLong(value);
                }
                case OM: {
                    return SynapseConfigUtils.stringToOM(value);
                }
                case SHORT: {
                    return Short.parseShort(value);
                }
            }
            return value;
        }
        catch (IllegalArgumentException e) {
            String msg = "Unknown type : " + type + " for the property mediator or the property value cannot be converted into the specified type.";
            this.log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    private String getMatchedValue(String value, SynapseLog synLog) {
        String matchedValue = value;
        Matcher matcher = this.pattern.matcher(value);
        if (matcher.matches()) {
            if (matcher.groupCount() >= this.group) {
                matchedValue = matcher.group(this.group);
            } else if (synLog.isTraceOrDebugEnabled()) {
                String msg = "Failed to get a match for regx : " + this.pattern.toString() + " with the property value :" + value + " for group :" + this.group;
                synLog.traceOrDebug(msg);
            }
        } else {
            if (synLog.isTraceOrDebugEnabled()) {
                String msg = "Unable to find a match for regx : " + this.pattern.toString() + " with the property value :" + value;
                synLog.traceOrDebug(msg);
            }
            matchedValue = "";
        }
        return matchedValue;
    }

    @Override
    public boolean isContentAware() {
        if (this.expression != null) {
            return this.expression.isContentAware();
        }
        boolean contentAware = false;
        if ("axis2".equals(this.scope)) {
            if ("messageType".equals(this.name)) {
                contentAware = true;
            }
        } else if ("transport".equals(this.scope) && "Content-Encoding".equals(this.name)) {
            contentAware = true;
        }
        return contentAware;
    }
}

