/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip.splitter;

import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.OperationContext;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class IterateMediator
extends AbstractMediator
implements ManagedLifecycle {
    private boolean continueParent = false;
    private boolean preservePayload = false;
    private SynapseXPath expression = null;
    private SynapseXPath attachPath = null;
    private Target target = null;
    private String id = null;

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Iterate mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        try {
            SOAPEnvelope envelope = MessageHelper.cloneSOAPEnvelope(synCtx.getEnvelope());
            List<OMNode> splitElements = EIPUtils.getDetachedMatchingElements(envelope, synCtx, this.expression);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Splitting with XPath : " + (Object)((Object)this.expression) + " resulted in " + splitElements.size() + " elements");
            }
            if (!this.preservePayload && envelope.getBody() != null) {
                envelope.getBody().removeChildren();
            }
            int msgCount = splitElements.size();
            int msgNumber = 0;
            for (OMNode o : splitElements) {
                if (!(o instanceof OMNode)) {
                    this.handleException("Error splitting message with XPath : " + (Object)((Object)this.expression) + " - result not an OMNode", synCtx);
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Submitting " + (msgNumber + 1) + " of " + msgNumber + (this.target.isAsynchronous() ? " messages for processing in parallel" : " messages for processing sequentially"));
                }
                this.target.mediate(this.getIteratedMessage(synCtx, msgNumber++, msgCount, envelope, o));
            }
        }
        catch (JaxenException e) {
            this.handleException("Error evaluating split XPath expression : " + (Object)((Object)this.expression), (Exception)((Object)e), synCtx);
        }
        catch (AxisFault af) {
            this.handleException("Error creating an iterated copy of the message", (Exception)((Object)af), synCtx);
        }
        OperationContext opCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getOperationContext();
        if (!this.continueParent && opCtx != null) {
            opCtx.setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        }
        synLog.traceOrDebug("End : Iterate mediator");
        return this.continueParent;
    }

    private MessageContext getIteratedMessage(MessageContext synCtx, int msgNumber, int msgCount, SOAPEnvelope envelope, OMNode o) throws AxisFault, JaxenException {
        MessageContext newCtx = MessageHelper.cloneMessageContext(synCtx);
        if (this.id != null) {
            newCtx.setProperty("aggregateCorelation." + this.id, synCtx.getMessageID());
            newCtx.setProperty("messageSequence." + this.id, msgNumber + "/" + msgCount);
        } else {
            newCtx.setProperty("messageSequence", msgNumber + "/" + msgCount);
        }
        SOAPEnvelope newEnvelope = MessageHelper.cloneSOAPEnvelope(envelope);
        if (this.preservePayload) {
            Object attachElem = this.attachPath.evaluate(newEnvelope, synCtx);
            if (attachElem != null && attachElem instanceof List && !((List)attachElem).isEmpty()) {
                attachElem = ((List)attachElem).get(0);
            }
            if (attachElem != null && attachElem instanceof OMElement) {
                ((OMElement)attachElem).addChild(o);
            } else {
                this.handleException("Error in attaching the splitted elements :: Unable to get the attach path specified by the expression " + (Object)((Object)this.attachPath), synCtx);
            }
        } else if (newEnvelope.getBody() != null) {
            newEnvelope.getBody().addChild(o);
        }
        newCtx.setEnvelope(newEnvelope);
        return newCtx;
    }

    public boolean isContinueParent() {
        return this.continueParent;
    }

    public void setContinueParent(boolean continueParent) {
        this.continueParent = continueParent;
    }

    public boolean isPreservePayload() {
        return this.preservePayload;
    }

    public void setPreservePayload(boolean preservePayload) {
        this.preservePayload = preservePayload;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }

    public SynapseXPath getAttachPath() {
        return this.attachPath;
    }

    public void setAttachPath(SynapseXPath attachPath) {
        this.attachPath = attachPath;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void init(SynapseEnvironment se) {
        if (this.target != null) {
            SequenceMediator seq;
            Endpoint endpoint = this.target.getEndpoint();
            if (endpoint != null) {
                endpoint.init(se);
            }
            if ((seq = this.target.getSequence()) != null) {
                seq.init(se);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.target != null) {
            SequenceMediator seq;
            Endpoint endpoint = this.target.getEndpoint();
            if (endpoint != null && endpoint.isInitialized()) {
                endpoint.destroy();
            }
            if ((seq = this.target.getSequence()) != null) {
                seq.destroy();
            }
        }
    }
}

