/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.velocity;

import com.sun.script.velocity.VelocityScriptEngineFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityScriptEngine
extends AbstractScriptEngine {
    public static final String STRING_OUTPUT_MODE = "com.sun.script.velocity.stringOutput";
    public static final String VELOCITY_PROPERTIES = "com.sun.script.velocity.properties";
    private volatile ScriptEngineFactory factory;
    private volatile VelocityEngine vengine;

    public VelocityScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    public VelocityScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    public VelocityEngine getVelocityEngine() {
        return this.vengine;
    }

    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        return this.eval((Reader)new StringReader(str), ctx);
    }

    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        this.initVelocityEngine(ctx);
        String fileName = VelocityScriptEngine.getFilename(ctx);
        VelocityContext vctx = VelocityScriptEngine.getVelocityContext(ctx);
        boolean outputAsString = VelocityScriptEngine.isStringOutputMode(ctx);
        Writer out = outputAsString ? new StringWriter() : ctx.getWriter();
        try {
            this.vengine.evaluate((Context)vctx, out, fileName, reader);
            out.flush();
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
        return outputAsString ? out.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            VelocityScriptEngine velocityScriptEngine = this;
            synchronized (velocityScriptEngine) {
                if (this.factory == null) {
                    this.factory = new VelocityScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initVelocityEngine(ScriptContext ctx) {
        if (this.vengine == null) {
            VelocityScriptEngine velocityScriptEngine = this;
            synchronized (velocityScriptEngine) {
                if (this.vengine != null) {
                    return;
                }
                Properties props = VelocityScriptEngine.getVelocityProperties(ctx);
                VelocityEngine tmpEngine = new VelocityEngine();
                try {
                    if (props != null) {
                        tmpEngine.init(props);
                    } else {
                        tmpEngine.init();
                    }
                }
                catch (RuntimeException rexp) {
                    throw rexp;
                }
                catch (Exception exp) {
                    throw new RuntimeException(exp);
                }
                this.vengine = tmpEngine;
            }
        }
    }

    private static VelocityContext getVelocityContext(ScriptContext ctx) {
        ctx.setAttribute("context", ctx, 100);
        Bindings globalScope = ctx.getBindings(200);
        Bindings engineScope = ctx.getBindings(100);
        if (globalScope != null) {
            return new VelocityContext((Map)engineScope, (Context)new VelocityContext((Map)globalScope));
        }
        return new VelocityContext((Map)engineScope);
    }

    private static String getFilename(ScriptContext ctx) {
        Object fileName = ctx.getAttribute("javax.script.filename");
        return fileName != null ? fileName.toString() : "<unknown>";
    }

    private static boolean isStringOutputMode(ScriptContext ctx) {
        Object flag = ctx.getAttribute(STRING_OUTPUT_MODE);
        return Boolean.TRUE.equals(flag);
    }

    private static Properties getVelocityProperties(ScriptContext ctx) {
        try {
            File propsFile;
            Object props = ctx.getAttribute(VELOCITY_PROPERTIES);
            if (props instanceof Properties) {
                return (Properties)props;
            }
            String propsName = System.getProperty(VELOCITY_PROPERTIES);
            if (propsName != null && (propsFile = new File(propsName)).exists() && propsFile.canRead()) {
                Properties p = new Properties();
                p.load(new FileInputStream(propsFile));
                return p;
            }
        }
        catch (Exception exp) {
            System.err.println(exp);
        }
        return null;
    }
}

