/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.sslcert.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.utils.sslcert.cache.ManageableCache;
import org.apache.synapse.transport.utils.sslcert.cache.ManageableCacheValue;

public class CacheManager {
    private static final Log log = LogFactory.getLog(CacheManager.class);
    private final boolean DO_NOT_INTERRUPT_IF_RUNNING = false;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture scheduledFuture = null;
    private ManageableCache cache;
    private int cacheMaxSize;
    private int duration;
    private CacheManagingTask cacheManagingTask;

    public CacheManager(ManageableCache cache, int cacheMaxSize, int duration) {
        this.cache = cache;
        this.cacheMaxSize = cacheMaxSize;
        this.cacheManagingTask = new CacheManagingTask();
        this.duration = duration;
        this.start();
    }

    private boolean start() {
        if (this.scheduledFuture == null || this.scheduledFuture.isCancelled()) {
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(this.cacheManagingTask, this.duration, this.duration, TimeUnit.MINUTES);
            log.info((Object)(this.cache.getClass().getSimpleName() + " Cache Manager Started"));
            return true;
        }
        return false;
    }

    public boolean wakeUpNow() {
        if (this.scheduledFuture != null) {
            if (!this.scheduledFuture.isCancelled()) {
                this.scheduledFuture.cancel(false);
            }
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(this.cacheManagingTask, 0L, this.duration, TimeUnit.MINUTES);
            log.info((Object)(this.cache.getClass().getSimpleName() + " Cache Manager Wakened Up....."));
            return true;
        }
        return false;
    }

    public boolean changeDuration(int duration) throws IllegalArgumentException {
        int min = 1;
        int max = 1440;
        if (duration < min || duration > max) {
            throw new IllegalArgumentException("Duration time should should be between " + min + " and " + max + " minutes");
        }
        this.duration = duration;
        return this.wakeUpNow();
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean stop() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(false);
            log.info((Object)(this.cache.getClass().getSimpleName() + " Cache Manager Stopped....."));
            return true;
        }
        return false;
    }

    public boolean isRunning() {
        return !this.scheduledFuture.isCancelled();
    }

    private class CacheManagingTask
    implements Runnable {
        private CacheManagingTask() {
        }

        @Override
        public void run() {
            int cacheSize;
            long start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)(CacheManager.this.cache.getClass().getSimpleName() + " Cache Manager Task Started."));
            }
            int numberToRemove = (cacheSize = CacheManager.this.cache.getCacheSize()) > CacheManager.this.cacheMaxSize ? cacheSize - CacheManager.this.cacheMaxSize : 0;
            ArrayList<ManageableCacheValue> entriesToRemove = new ArrayList<ManageableCacheValue>();
            LRUEntryCollector lruEntryCollector = new LRUEntryCollector(entriesToRemove, numberToRemove);
            CacheManager.this.cache.resetIterator();
            while (cacheSize-- > 0) {
                ManageableCacheValue nextCacheValue = CacheManager.this.cache.getNextCacheValue();
                if (nextCacheValue == null) {
                    log.debug((Object)"Cache manager iteration through Cache values done");
                    break;
                }
                if (!nextCacheValue.isValid()) {
                    log.debug((Object)"Updating Invalid Cache Value by Manager");
                    nextCacheValue.updateCacheWithNewValue();
                }
                if (numberToRemove <= 0) continue;
                lruEntryCollector.collectEntriesToRemove(nextCacheValue);
            }
            for (ManageableCacheValue oldCacheValue : entriesToRemove) {
                log.debug((Object)"Removing LRU value from cache");
                oldCacheValue.removeThisCacheValue();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(CacheManager.this.cache.getClass().getSimpleName() + " Cache Manager Task Done. Took " + (System.currentTimeMillis() - start) + " ms."));
            }
        }

        private class LRUEntryCollector {
            private List<ManageableCacheValue> entriesToRemove;
            private int listMaxSize;

            LRUEntryCollector(List<ManageableCacheValue> entriesToRemove, int numberToRemove) {
                this.entriesToRemove = entriesToRemove;
                this.listMaxSize = numberToRemove;
            }

            private void collectEntriesToRemove(ManageableCacheValue value) {
                int i;
                this.entriesToRemove.add(value);
                for (i = this.entriesToRemove.size() - 1; i > 0 && value.getTimeStamp() < this.entriesToRemove.get(i - 1).getTimeStamp(); --i) {
                    this.entriesToRemove.remove(i);
                    this.entriesToRemove.add(i, this.entriesToRemove.get(i - 1));
                }
                this.entriesToRemove.remove(i);
                this.entriesToRemove.add(i, value);
                if (this.entriesToRemove.size() > this.listMaxSize) {
                    this.entriesToRemove.remove(this.entriesToRemove.size() - 1);
                }
            }
        }
    }
}

