/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.sslcert.ocsp;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.utils.sslcert.CertificateVerificationException;
import org.apache.synapse.transport.utils.sslcert.RevocationStatus;
import org.apache.synapse.transport.utils.sslcert.RevocationVerifier;
import org.apache.synapse.transport.utils.sslcert.ocsp.OCSPCache;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class OCSPVerifier
implements RevocationVerifier {
    private static final Log log = LogFactory.getLog(OCSPVerifier.class);
    private OCSPCache cache;

    public OCSPVerifier(OCSPCache cache) {
        this.cache = cache;
    }

    @Override
    public RevocationStatus checkRevocationStatus(X509Certificate peerCert, X509Certificate issuerCert) throws CertificateVerificationException {
        SingleResp resp;
        if (this.cache != null && (resp = this.cache.getCacheValue(peerCert.getSerialNumber())) != null) {
            RevocationStatus status = this.getRevocationStatus(resp);
            log.debug((Object)"OCSP response taken from cache....");
            return status;
        }
        OCSPReq request = this.generateOCSPRequest(issuerCert, peerCert.getSerialNumber());
        List<String> locations = this.getAIALocations(peerCert);
        for (String serviceUrl : locations) {
            SingleResp[] responses;
            try {
                OCSPResp ocspResponse = this.getOCSPResponse(serviceUrl, request);
                if (0 != ocspResponse.getStatus()) continue;
                BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResponse.getResponseObject();
                responses = basicResponse == null ? null : basicResponse.getResponses();
            }
            catch (Exception e) {
                continue;
            }
            if (responses == null || responses.length != 1) continue;
            SingleResp resp2 = responses[0];
            RevocationStatus status = this.getRevocationStatus(resp2);
            if (this.cache != null) {
                this.cache.setCacheValue(peerCert.getSerialNumber(), resp2, request, serviceUrl);
            }
            return status;
        }
        throw new CertificateVerificationException("Cant get Revocation Status from OCSP.");
    }

    private RevocationStatus getRevocationStatus(SingleResp resp) throws CertificateVerificationException {
        CertificateStatus status = resp.getCertStatus();
        if (status == CertificateStatus.GOOD) {
            return RevocationStatus.GOOD;
        }
        if (status instanceof RevokedStatus) {
            return RevocationStatus.REVOKED;
        }
        if (status instanceof UnknownStatus) {
            return RevocationStatus.UNKNOWN;
        }
        throw new CertificateVerificationException("Cant recognize Certificate Status");
    }

    protected OCSPResp getOCSPResponse(String serviceUrl, OCSPReq request) throws CertificateVerificationException {
        try {
            byte[] array = request.getEncoded();
            if (serviceUrl.startsWith("http")) {
                URL url = new URL(serviceUrl);
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestProperty("Content-Type", "application/ocsp-request");
                con.setRequestProperty("Accept", "application/ocsp-response");
                con.setDoOutput(true);
                OutputStream out = con.getOutputStream();
                DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
                dataOut.write(array);
                dataOut.flush();
                dataOut.close();
                if (con.getResponseCode() / 100 != 2) {
                    throw new CertificateVerificationException("Error getting ocsp response.Response code is " + con.getResponseCode());
                }
                InputStream in = (InputStream)con.getContent();
                return new OCSPResp(in);
            }
            throw new CertificateVerificationException("Only http is supported for ocsp calls");
        }
        catch (IOException e) {
            throw new CertificateVerificationException("Cannot get ocspResponse from url: " + serviceUrl, e);
        }
    }

    private OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws CertificateVerificationException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            DigestCalculator digestCalculator = new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1);
            CertificateID id = new CertificateID(digestCalculator, (X509CertificateHolder)new JcaX509CertificateHolder(issuerCert), serialNumber);
            OCSPReqBuilder builder = new OCSPReqBuilder();
            builder.addRequest(id);
            BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
            Extension ext = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(new DEROctetString(nonce.toByteArray()).getEncoded()));
            builder.setRequestExtensions(new Extensions(new Extension[]{ext}));
            return builder.build();
        }
        catch (IOException | CertificateEncodingException | OCSPException | OperatorCreationException e) {
            throw new CertificateVerificationException("Cannot generate OCSP Request with the given certificate", e);
        }
    }

    private List<String> getAIALocations(X509Certificate cert) throws CertificateVerificationException {
        AccessDescription[] accessDescriptions;
        AuthorityInformationAccess authorityInformationAccess;
        byte[] aiaExtensionValue = cert.getExtensionValue(X509Extensions.AuthorityInfoAccess.getId());
        if (aiaExtensionValue == null) {
            throw new CertificateVerificationException("Certificate doesn't have authority information access points");
        }
        ASN1InputStream asn1In = new ASN1InputStream(aiaExtensionValue);
        try {
            DEROctetString aiaDEROctetString = (DEROctetString)asn1In.readObject();
            ASN1InputStream asn1InOctets = new ASN1InputStream(aiaDEROctetString.getOctets());
            ASN1Sequence aiaASN1Sequence = (ASN1Sequence)asn1InOctets.readObject();
            authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)aiaASN1Sequence);
        }
        catch (IOException e) {
            throw new CertificateVerificationException("Cannot read certificate to get OCSP URLs", e);
        }
        ArrayList<String> ocspUrlList = new ArrayList<String>();
        for (AccessDescription accessDescription : accessDescriptions = authorityInformationAccess.getAccessDescriptions()) {
            GeneralName gn = accessDescription.getAccessLocation();
            if (gn.getTagNo() != 6) continue;
            DERIA5String str = DERIA5String.getInstance((Object)gn.getName());
            String accessLocation = str.getString();
            ocspUrlList.add(accessLocation);
        }
        if (ocspUrlList.isEmpty()) {
            throw new CertificateVerificationException("Cant get OCSP urls from certificate");
        }
        return ocspUrlList;
    }
}

