/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.sysml.api.mlcontext.FrameMetadata;
import org.apache.sysml.api.mlcontext.MLContextConversionUtil;
import org.apache.sysml.api.mlcontext.MLContextException;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.FrameBlock;

public class Frame {
    private FrameObject frameObject;
    private SparkExecutionContext sparkExecutionContext;
    private JavaPairRDD<Long, FrameBlock> binaryBlocks;
    private FrameMetadata frameMetadata;

    public Frame(FrameObject frameObject, SparkExecutionContext sparkExecutionContext) {
        this.frameObject = frameObject;
        this.sparkExecutionContext = sparkExecutionContext;
        this.frameMetadata = new FrameMetadata(frameObject.getMatrixCharacteristics());
    }

    public Frame(Dataset<Row> dataFrame, FrameMetadata frameMetadata) {
        this.frameMetadata = frameMetadata;
        this.binaryBlocks = MLContextConversionUtil.dataFrameToFrameBinaryBlocks(dataFrame, frameMetadata);
    }

    public Frame(Dataset<Row> dataFrame, long numRows, long numCols) {
        this(dataFrame, new FrameMetadata(numRows, (Long)numCols, (Integer)ConfigurationManager.getBlocksize(), (Integer)ConfigurationManager.getBlocksize()));
    }

    public Frame(Dataset<Row> dataFrame) {
        this(dataFrame, new FrameMetadata());
    }

    public Frame(JavaPairRDD<Long, FrameBlock> binaryBlocks, FrameMetadata frameMetadata) {
        this.binaryBlocks = binaryBlocks;
        this.frameMetadata = frameMetadata;
    }

    public FrameObject toFrameObject() {
        return this.frameObject;
    }

    public String[][] to2DStringArray() {
        return MLContextConversionUtil.frameObjectTo2DStringArray(this.frameObject);
    }

    public JavaRDD<String> toJavaRDDStringIJV() {
        return MLContextConversionUtil.frameObjectToJavaRDDStringIJV(this.frameObject);
    }

    public JavaRDD<String> toJavaRDDStringCSV() {
        return MLContextConversionUtil.frameObjectToJavaRDDStringCSV(this.frameObject, ",");
    }

    public RDD<String> toRDDStringCSV() {
        return MLContextConversionUtil.frameObjectToRDDStringCSV(this.frameObject, ",");
    }

    public RDD<String> toRDDStringIJV() {
        return MLContextConversionUtil.frameObjectToRDDStringIJV(this.frameObject);
    }

    public Dataset<Row> toDF() {
        return MLContextConversionUtil.frameObjectToDataFrame(this.frameObject, this.sparkExecutionContext);
    }

    public JavaPairRDD<Long, FrameBlock> toBinaryBlocks() {
        if (this.binaryBlocks != null) {
            return this.binaryBlocks;
        }
        if (this.frameObject != null) {
            this.binaryBlocks = MLContextConversionUtil.frameObjectToBinaryBlocks(this.frameObject, this.sparkExecutionContext);
            MatrixCharacteristics mc = this.frameObject.getMatrixCharacteristics();
            this.frameMetadata = new FrameMetadata(mc);
            return this.binaryBlocks;
        }
        throw new MLContextException("No binary blocks or FrameObject found");
    }

    public FrameMetadata getFrameMetadata() {
        return this.frameMetadata;
    }

    public String toString() {
        return this.frameObject.toString();
    }

    public boolean hasBinaryBlocks() {
        return this.binaryBlocks != null;
    }

    public boolean hasFrameObject() {
        return this.frameObject != null;
    }
}

