/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.HashMap;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.ParseInfo;
import org.apache.sysml.parser.VariableSet;

public class BooleanExpression
extends Expression {
    private Expression _left;
    private Expression _right;
    private Expression.BooleanOp _opcode;

    public BooleanExpression(Expression.BooleanOp bop) {
        this._opcode = bop;
        this.setFilename("MAIN SCRIPT");
        this.setBeginLine(0);
        this.setBeginColumn(0);
        this.setEndLine(0);
        this.setEndColumn(0);
        this.setText(null);
    }

    public BooleanExpression(Expression.BooleanOp bop, ParseInfo parseInfo) {
        this._opcode = bop;
        this.setParseInfo(parseInfo);
    }

    public Expression.BooleanOp getOpCode() {
        return this._opcode;
    }

    public void setLeft(Expression l) {
        this._left = l;
        if (this._left != null) {
            this.setParseInfo(this._left);
        }
    }

    public void setRight(Expression r) {
        this._right = r;
        if (this._right != null) {
            this.setParseInfo(this._right);
        }
    }

    public Expression getLeft() {
        return this._left;
    }

    public Expression getRight() {
        return this._right;
    }

    @Override
    public Expression rewriteExpression(String prefix) {
        BooleanExpression newExpr = new BooleanExpression(this._opcode, this);
        newExpr.setLeft(this._left.rewriteExpression(prefix));
        if (this._right != null) {
            newExpr.setRight(this._right.rewriteExpression(prefix));
        }
        return newExpr;
    }

    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) {
        this.getLeft().validateExpression(ids, constVars, conditional);
        if (this._left instanceof FunctionCallIdentifier) {
            this.raiseValidateError("user-defined function calls not supported in boolean expressions", false, "Unsupported Expression");
        }
        if (this.getRight() != null) {
            if (this._right instanceof FunctionCallIdentifier) {
                this.raiseValidateError("user-defined function calls not supported in boolean expressions", false, "Unsupported Expression");
            }
            this.getRight().validateExpression(ids, constVars, conditional);
        }
        String outputName = BooleanExpression.getTempName();
        DataIdentifier output = new DataIdentifier(outputName);
        output.setParseInfo(this);
        if (this.getLeft().getOutput().getDataType().isMatrix() || this.getRight() != null && this.getRight().getOutput().getDataType().isMatrix()) {
            output.setDataType(this.getRight() == null ? Expression.DataType.MATRIX : BooleanExpression.computeDataType(this.getLeft(), this.getRight(), true));
            output.setValueType(Expression.ValueType.DOUBLE);
        } else {
            output.setBooleanProperties();
        }
        this.setOutput(output);
        if (this._opcode == Expression.BooleanOp.CONDITIONALAND || this._opcode == Expression.BooleanOp.CONDITIONALOR) {
            if (this._opcode == Expression.BooleanOp.CONDITIONALAND) {
                this.raiseValidateError("Conditional AND (&&) not supported.", false);
            } else if (this._opcode == Expression.BooleanOp.CONDITIONALOR) {
                this.raiseValidateError("Conditional OR (||) not supported.", false);
            }
        }
    }

    public String toString() {
        if (this._opcode == Expression.BooleanOp.NOT) {
            return "(" + this._opcode.toString() + " " + this._left.toString() + ")";
        }
        return "(" + this._left.toString() + " " + this._opcode.toString() + " " + this._right.toString() + ")";
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariables(this._left.variablesRead());
        if (this._right != null) {
            result.addVariables(this._right.variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        result.addVariables(this._left.variablesUpdated());
        if (this._right != null) {
            result.addVariables(this._right.variablesUpdated());
        }
        return result;
    }
}

