/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.sysml.runtime.controlprogram.parfor.ResultMergeTaggedMatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixBlock;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;

public class ResultMergeRemotePartitioning
implements Partitioner<ResultMergeTaggedMatrixIndexes, TaggedMatrixBlock> {
    private long _numColBlocks = -1L;

    public int getPartition(ResultMergeTaggedMatrixIndexes key, TaggedMatrixBlock val, int numPartitions) {
        MatrixIndexes ix = key.getIndexes();
        int blockid = (int)(ix.getRowIndex() * this._numColBlocks + ix.getColumnIndex());
        int partition = blockid % numPartitions;
        return partition;
    }

    public void configure(JobConf job) {
        long[] tmp = MRJobConfiguration.getResultMergeMatrixCharacteristics(job);
        long clen = tmp[1];
        int bclen = (int)tmp[3];
        this._numColBlocks = clen / (long)bclen + (long)(clen % (long)bclen != 0L ? 1 : 0);
    }
}

