/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.functionobjects.OffsetColumnIndex;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.ReorgOperator;
import org.apache.sysml.runtime.util.UtilFunctions;
import scala.Tuple2;

public class AppendGSPInstruction
extends BinarySPInstruction {
    private boolean _cbind = true;

    private AppendGSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand offset, CPOperand offset2, CPOperand out, boolean cbind, String opcode, String istr) {
        super(SPInstruction.SPType.GAppend, op, in1, in2, out, opcode, istr);
        this._cbind = cbind;
    }

    public static AppendGSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 6);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand in4 = new CPOperand(parts[4]);
        CPOperand out = new CPOperand(parts[5]);
        boolean cbind = Boolean.parseBoolean(parts[6]);
        if (!opcode.equalsIgnoreCase("gappend")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a AppendGSPInstruction: " + str);
        }
        return new AppendGSPInstruction(new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1)), in1, in2, in3, in4, out, cbind, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        this.checkBinaryAppendInputCharacteristics(sec, this._cbind, false, false);
        MatrixCharacteristics mc1 = sec.getMatrixCharacteristics(this.input1.getName());
        MatrixCharacteristics mc2 = sec.getMatrixCharacteristics(this.input2.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> in2 = sec.getBinaryBlockRDDHandleForVariable(this.input2.getName());
        JavaPairRDD out = null;
        JavaPairRDD shifted_in2 = in2.flatMapToPair((PairFlatMapFunction)new ShiftMatrix(mc1, mc2, this._cbind));
        out = in1.cogroup(shifted_in2).mapToPair((PairFunction)new MergeWithShiftedBlocks(mc1, mc2, this._cbind));
        this.updateBinaryAppendOutputMatrixCharacteristics(sec, this._cbind);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        sec.addLineageRDD(this.output.getName(), this.input2.getName());
    }

    public static class ShiftMatrix
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 3524189212798209172L;
        private boolean _cbind;
        private long _startIx;
        private int _shiftBy;
        private int _blen;
        private long _outlen;

        public ShiftMatrix(MatrixCharacteristics mc1, MatrixCharacteristics mc2, boolean cbind) {
            this._cbind = cbind;
            this._startIx = cbind ? UtilFunctions.computeBlockIndex(mc1.getCols(), mc1.getColsPerBlock()) : UtilFunctions.computeBlockIndex(mc1.getRows(), mc1.getRowsPerBlock());
            this._blen = cbind ? mc1.getColsPerBlock() : mc1.getRowsPerBlock();
            this._shiftBy = (int)(cbind ? mc1.getCols() % (long)this._blen : mc1.getRows() % (long)this._blen);
            this._outlen = cbind ? mc1.getCols() + mc2.getCols() : mc1.getRows() + mc2.getRows();
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> kv) throws Exception {
            ArrayList<Tuple2> retVal = new ArrayList<Tuple2>();
            MatrixIndexes ix = (MatrixIndexes)kv._1();
            MatrixBlock in = (MatrixBlock)kv._2();
            int cutAt = this._blen - this._shiftBy;
            if (this._cbind) {
                MatrixIndexes firstIndex = new MatrixIndexes(ix.getRowIndex(), ix.getColumnIndex() + this._startIx - 1L);
                MatrixIndexes secondIndex = new MatrixIndexes(ix.getRowIndex(), ix.getColumnIndex() + this._startIx);
                int lblen1 = UtilFunctions.computeBlockSize(this._outlen, firstIndex.getColumnIndex(), this._blen);
                if (cutAt >= in.getNumColumns()) {
                    MatrixBlock firstBlk = new MatrixBlock(in.getNumRows(), lblen1, true);
                    firstBlk = firstBlk.leftIndexingOperations(in, 0, in.getNumRows() - 1, lblen1 - in.getNumColumns(), lblen1 - 1, new MatrixBlock(), MatrixObject.UpdateType.INPLACE_PINNED);
                    retVal.add(new Tuple2((Object)firstIndex, (Object)firstBlk));
                } else {
                    MatrixBlock firstSlicedBlk = in.slice(0, in.getNumRows() - 1, 0, cutAt - 1, new MatrixBlock());
                    MatrixBlock firstBlk = new MatrixBlock(in.getNumRows(), lblen1, true);
                    firstBlk = firstBlk.leftIndexingOperations(firstSlicedBlk, 0, in.getNumRows() - 1, this._shiftBy, this._blen - 1, new MatrixBlock(), MatrixObject.UpdateType.INPLACE_PINNED);
                    MatrixBlock secondSlicedBlk = in.slice(0, in.getNumRows() - 1, cutAt, in.getNumColumns() - 1, new MatrixBlock());
                    int llen2 = UtilFunctions.computeBlockSize(this._outlen, secondIndex.getColumnIndex(), this._blen);
                    MatrixBlock secondBlk = new MatrixBlock(in.getNumRows(), llen2, true);
                    secondBlk = secondBlk.leftIndexingOperations(secondSlicedBlk, 0, in.getNumRows() - 1, 0, secondSlicedBlk.getNumColumns() - 1, new MatrixBlock(), MatrixObject.UpdateType.INPLACE_PINNED);
                    retVal.add(new Tuple2((Object)firstIndex, (Object)firstBlk));
                    retVal.add(new Tuple2((Object)secondIndex, (Object)secondBlk));
                }
            } else {
                MatrixIndexes firstIndex = new MatrixIndexes(ix.getRowIndex() + this._startIx - 1L, ix.getColumnIndex());
                MatrixIndexes secondIndex = new MatrixIndexes(ix.getRowIndex() + this._startIx, ix.getColumnIndex());
                int lblen1 = UtilFunctions.computeBlockSize(this._outlen, firstIndex.getRowIndex(), this._blen);
                if (cutAt >= in.getNumRows()) {
                    MatrixBlock firstBlk = new MatrixBlock(lblen1, in.getNumColumns(), true);
                    firstBlk = firstBlk.leftIndexingOperations(in, lblen1 - in.getNumRows(), lblen1 - 1, 0, in.getNumColumns() - 1, new MatrixBlock(), MatrixObject.UpdateType.INPLACE_PINNED);
                    retVal.add(new Tuple2((Object)firstIndex, (Object)firstBlk));
                } else {
                    MatrixBlock firstSlicedBlk = in.slice(0, cutAt - 1);
                    MatrixBlock firstBlk = new MatrixBlock(lblen1, in.getNumColumns(), true);
                    firstBlk = firstBlk.leftIndexingOperations(firstSlicedBlk, this._shiftBy, this._blen - 1, 0, in.getNumColumns() - 1, new MatrixBlock(), MatrixObject.UpdateType.INPLACE_PINNED);
                    MatrixBlock secondSlicedBlk = in.slice(cutAt, in.getNumRows() - 1, 0, in.getNumColumns() - 1, new MatrixBlock());
                    int lblen2 = UtilFunctions.computeBlockSize(this._outlen, secondIndex.getRowIndex(), this._blen);
                    MatrixBlock secondBlk = new MatrixBlock(lblen2, in.getNumColumns(), true);
                    secondBlk = secondBlk.leftIndexingOperations(secondSlicedBlk, 0, secondSlicedBlk.getNumRows() - 1, 0, in.getNumColumns() - 1, new MatrixBlock(), MatrixObject.UpdateType.INPLACE_PINNED);
                    retVal.add(new Tuple2((Object)firstIndex, (Object)firstBlk));
                    retVal.add(new Tuple2((Object)secondIndex, (Object)secondBlk));
                }
            }
            return retVal.iterator();
        }
    }

    public static class MergeWithShiftedBlocks
    implements PairFunction<Tuple2<MatrixIndexes, Tuple2<Iterable<MatrixBlock>, Iterable<MatrixBlock>>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 848955582909209400L;
        private boolean _cbind;
        private long _lastIxLeft;
        private int _blen;

        public MergeWithShiftedBlocks(MatrixCharacteristics mc1, MatrixCharacteristics mc2, boolean cbind) {
            this._cbind = cbind;
            this._blen = cbind ? mc1.getColsPerBlock() : mc1.getRowsPerBlock();
            this._lastIxLeft = (long)Math.ceil((double)(cbind ? mc1.getCols() : mc1.getRows()) / (double)this._blen);
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, Tuple2<Iterable<MatrixBlock>, Iterable<MatrixBlock>>> kv) throws Exception {
            long ix;
            Iterator iterLeft = ((Iterable)((Tuple2)kv._2)._1).iterator();
            Iterator iterRight = ((Iterable)((Tuple2)kv._2)._2).iterator();
            if (!iterLeft.hasNext()) {
                MatrixBlock tmp = (MatrixBlock)iterRight.next();
                if (iterRight.hasNext()) {
                    tmp.merge((MatrixBlock)iterRight.next(), false);
                }
                return new Tuple2(kv._1, (Object)tmp);
            }
            if (!iterRight.hasNext()) {
                return new Tuple2(kv._1, iterLeft.next());
            }
            MatrixBlock firstBlk = (MatrixBlock)iterLeft.next();
            MatrixBlock secondBlk = (MatrixBlock)iterRight.next();
            long l = ix = this._cbind ? ((MatrixIndexes)kv._1).getColumnIndex() : ((MatrixIndexes)kv._1).getRowIndex();
            if (ix == this._lastIxLeft && (this._cbind && firstBlk.getNumColumns() < secondBlk.getNumColumns() || !this._cbind && firstBlk.getNumRows() < secondBlk.getNumRows())) {
                MatrixBlock tmp = new MatrixBlock(secondBlk.getNumRows(), secondBlk.getNumColumns(), true);
                firstBlk = tmp.leftIndexingOperations(firstBlk, 0, firstBlk.getNumRows() - 1, 0, firstBlk.getNumColumns() - 1, new MatrixBlock(), MatrixObject.UpdateType.INPLACE_PINNED);
            }
            firstBlk.merge(secondBlk, false);
            return new Tuple2(kv._1, (Object)firstBlk);
        }
    }
}

