/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.MMTSJ;
import org.apache.sysml.runtime.instructions.mr.AggregateBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.AggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.AggregateUnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.AppendInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryMInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryMRInstructionBase;
import org.apache.sysml.runtime.instructions.mr.CM_N_COVInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineTernaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineUnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CtableInstruction;
import org.apache.sysml.runtime.instructions.mr.CumulativeAggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.DataGenMRInstruction;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateMInstruction;
import org.apache.sysml.runtime.instructions.mr.MMTSJMRInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.MapMultChainInstruction;
import org.apache.sysml.runtime.instructions.mr.MatrixReshapeMRInstruction;
import org.apache.sysml.runtime.instructions.mr.PMMJMRInstruction;
import org.apache.sysml.runtime.instructions.mr.ParameterizedBuiltinMRInstruction;
import org.apache.sysml.runtime.instructions.mr.QuaternaryInstruction;
import org.apache.sysml.runtime.instructions.mr.RandInstruction;
import org.apache.sysml.runtime.instructions.mr.RangeBasedReIndexInstruction;
import org.apache.sysml.runtime.instructions.mr.ReblockInstruction;
import org.apache.sysml.runtime.instructions.mr.RemoveEmptyMRInstruction;
import org.apache.sysml.runtime.instructions.mr.ReorgInstruction;
import org.apache.sysml.runtime.instructions.mr.ReplicateInstruction;
import org.apache.sysml.runtime.instructions.mr.ScalarInstruction;
import org.apache.sysml.runtime.instructions.mr.SeqInstruction;
import org.apache.sysml.runtime.instructions.mr.TernaryInstruction;
import org.apache.sysml.runtime.instructions.mr.UaggOuterChainInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.instructions.mr.ZeroOutInstruction;
import org.apache.sysml.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.ReorgOperator;

public class MatrixCharacteristics
implements Serializable {
    private static final long serialVersionUID = 8300479822915546000L;
    private long numRows = -1L;
    private long numColumns = -1L;
    private int numRowsPerBlock = 1;
    private int numColumnsPerBlock = 1;
    private long nonZero = -1L;
    private boolean ubNnz = false;

    public MatrixCharacteristics() {
    }

    public MatrixCharacteristics(long nr, long nc, long nnz) {
        this.set(nr, nc, -1, -1, nnz);
    }

    public MatrixCharacteristics(long nr, long nc, int bnr, int bnc) {
        this.set(nr, nc, bnr, bnc);
    }

    public MatrixCharacteristics(long nr, long nc, int bnr, int bnc, long nnz) {
        this.set(nr, nc, bnr, bnc, nnz);
    }

    public MatrixCharacteristics(MatrixCharacteristics that) {
        this.set(that.numRows, that.numColumns, that.numRowsPerBlock, that.numColumnsPerBlock, that.nonZero);
    }

    public MatrixCharacteristics set(long nr, long nc, int bnr, int bnc) {
        this.numRows = nr;
        this.numColumns = nc;
        this.numRowsPerBlock = bnr;
        this.numColumnsPerBlock = bnc;
        return this;
    }

    public MatrixCharacteristics set(long nr, long nc, int bnr, int bnc, long nnz) {
        this.numRows = nr;
        this.numColumns = nc;
        this.numRowsPerBlock = bnr;
        this.numColumnsPerBlock = bnc;
        this.nonZero = nnz;
        this.ubNnz = false;
        return this;
    }

    public MatrixCharacteristics set(MatrixCharacteristics that) {
        this.numRows = that.numRows;
        this.numColumns = that.numColumns;
        this.numRowsPerBlock = that.numRowsPerBlock;
        this.numColumnsPerBlock = that.numColumnsPerBlock;
        this.nonZero = that.nonZero;
        this.ubNnz = that.ubNnz;
        return this;
    }

    public long getRows() {
        return this.numRows;
    }

    public void setRows(long rlen) {
        this.numRows = rlen;
    }

    public long getCols() {
        return this.numColumns;
    }

    public void setCols(long clen) {
        this.numColumns = clen;
    }

    public long getLength() {
        return this.numRows * this.numColumns;
    }

    public int getRowsPerBlock() {
        return this.numRowsPerBlock;
    }

    public void setRowsPerBlock(int brlen) {
        this.numRowsPerBlock = brlen;
    }

    public int getColsPerBlock() {
        return this.numColumnsPerBlock;
    }

    public void setColsPerBlock(int bclen) {
        this.numColumnsPerBlock = bclen;
    }

    public long getNumBlocks() {
        return this.getNumRowBlocks() * this.getNumColBlocks();
    }

    public long getNumRowBlocks() {
        return Math.max((long)Math.ceil((double)this.getRows() / (double)this.getRowsPerBlock()), 1L);
    }

    public long getNumColBlocks() {
        return Math.max((long)Math.ceil((double)this.getCols() / (double)this.getColsPerBlock()), 1L);
    }

    public String toString() {
        return "[" + this.numRows + " x " + this.numColumns + ", nnz=" + this.nonZero + " (" + this.ubNnz + "), blocks (" + this.numRowsPerBlock + " x " + this.numColumnsPerBlock + ")]";
    }

    public void setDimension(long nr, long nc) {
        this.numRows = nr;
        this.numColumns = nc;
    }

    public MatrixCharacteristics setBlockSize(int blen) {
        return this.setBlockSize(blen, blen);
    }

    public MatrixCharacteristics setBlockSize(int bnr, int bnc) {
        this.numRowsPerBlock = bnr;
        this.numColumnsPerBlock = bnc;
        return this;
    }

    public void setNonZeros(long nnz) {
        this.ubNnz = false;
        this.nonZero = nnz;
    }

    public long getNonZeros() {
        return !this.ubNnz ? this.nonZero : -1L;
    }

    public void setNonZerosBound(long nnz) {
        this.ubNnz = true;
        this.nonZero = nnz;
    }

    public long getNonZerosBound() {
        return this.nonZero;
    }

    public double getSparsity() {
        return OptimizerUtils.getSparsity(this);
    }

    public boolean dimsKnown() {
        return this.numRows >= 0L && this.numColumns >= 0L;
    }

    public boolean dimsKnown(boolean includeNnz) {
        return this.numRows >= 0L && this.numColumns >= 0L && (!includeNnz || this.nnzKnown());
    }

    public boolean rowsKnown() {
        return this.numRows >= 0L;
    }

    public boolean colsKnown() {
        return this.numColumns >= 0L;
    }

    public boolean nnzKnown() {
        return !this.ubNnz && this.nonZero >= 0L;
    }

    public boolean isUltraSparse() {
        return this.dimsKnown(true) && OptimizerUtils.getSparsity(this) < 4.0E-5;
    }

    public boolean mightHaveEmptyBlocks() {
        long singleBlk = Math.max(Math.min(this.numRows, (long)this.numRowsPerBlock), 1L) * Math.max(Math.min(this.numColumns, (long)this.numColumnsPerBlock), 1L);
        return !this.nnzKnown() || this.numRows == 0L || this.numColumns == 0L || this.nonZero < this.numRows * this.numColumns - singleBlk;
    }

    public static void reorg(MatrixCharacteristics dim, ReorgOperator op, MatrixCharacteristics dimOut) {
        op.fn.computeDimension(dim, dimOut);
    }

    public static void aggregateUnary(MatrixCharacteristics dim, AggregateUnaryOperator op, MatrixCharacteristics dimOut) {
        op.indexFn.computeDimension(dim, dimOut);
    }

    public static void aggregateBinary(MatrixCharacteristics dim1, MatrixCharacteristics dim2, AggregateBinaryOperator op, MatrixCharacteristics dimOut) {
        dimOut.set(dim1.numRows, dim2.numColumns, dim1.numRowsPerBlock, dim2.numColumnsPerBlock);
    }

    public static void computeDimension(HashMap<Byte, MatrixCharacteristics> dims, MRInstruction ins) {
        MatrixCharacteristics dimOut = dims.get(ins.output);
        if (dimOut == null) {
            dimOut = new MatrixCharacteristics();
            dims.put(ins.output, dimOut);
        }
        if (ins instanceof ReorgInstruction) {
            ReorgInstruction realIns = (ReorgInstruction)ins;
            MatrixCharacteristics.reorg(dims.get(realIns.input), (ReorgOperator)realIns.getOperator(), dimOut);
        } else if (ins instanceof AppendInstruction) {
            AppendInstruction realIns = (AppendInstruction)ins;
            MatrixCharacteristics in_dim1 = dims.get(realIns.input1);
            MatrixCharacteristics in_dim2 = dims.get(realIns.input2);
            if (realIns.isCBind()) {
                dimOut.set(in_dim1.numRows, in_dim1.numColumns + in_dim2.numColumns, in_dim1.numRowsPerBlock, in_dim2.numColumnsPerBlock);
            } else {
                dimOut.set(in_dim1.numRows + in_dim2.numRows, in_dim1.numColumns, in_dim1.numRowsPerBlock, in_dim2.numColumnsPerBlock);
            }
        } else if (ins instanceof CumulativeAggregateInstruction) {
            AggregateUnaryInstruction realIns = (AggregateUnaryInstruction)ins;
            MatrixCharacteristics in = dims.get(realIns.input);
            dimOut.set((long)Math.ceil((double)in.getRows() / (double)in.getRowsPerBlock()), in.getCols(), in.getRowsPerBlock(), in.getColsPerBlock());
        } else if (ins instanceof AggregateUnaryInstruction) {
            AggregateUnaryInstruction realIns = (AggregateUnaryInstruction)ins;
            MatrixCharacteristics.aggregateUnary(dims.get(realIns.input), (AggregateUnaryOperator)realIns.getOperator(), dimOut);
        } else if (ins instanceof AggregateBinaryInstruction) {
            AggregateBinaryInstruction realIns = (AggregateBinaryInstruction)ins;
            MatrixCharacteristics.aggregateBinary(dims.get(realIns.input1), dims.get(realIns.input2), (AggregateBinaryOperator)realIns.getOperator(), dimOut);
        } else if (ins instanceof MapMultChainInstruction) {
            MapMultChainInstruction realIns = (MapMultChainInstruction)ins;
            MatrixCharacteristics mc1 = dims.get(realIns.getInput1());
            MatrixCharacteristics mc2 = dims.get(realIns.getInput2());
            dimOut.set(mc1.numColumns, mc2.numColumns, mc1.numRowsPerBlock, mc1.numColumnsPerBlock);
        } else if (ins instanceof QuaternaryInstruction) {
            QuaternaryInstruction realIns = (QuaternaryInstruction)ins;
            MatrixCharacteristics mc1 = dims.get(realIns.getInput1());
            MatrixCharacteristics mc2 = dims.get(realIns.getInput2());
            MatrixCharacteristics mc3 = dims.get(realIns.getInput3());
            realIns.computeMatrixCharacteristics(mc1, mc2, mc3, dimOut);
        } else if (ins instanceof ReblockInstruction) {
            ReblockInstruction realIns = (ReblockInstruction)ins;
            MatrixCharacteristics in_dim = dims.get(realIns.input);
            dimOut.set(in_dim.numRows, in_dim.numColumns, realIns.brlen, realIns.bclen, in_dim.nonZero);
        } else if (ins instanceof MatrixReshapeMRInstruction) {
            MatrixReshapeMRInstruction mrinst = (MatrixReshapeMRInstruction)ins;
            MatrixCharacteristics in_dim = dims.get(mrinst.input);
            dimOut.set(mrinst.getNumRows(), mrinst.getNumColunms(), in_dim.getRowsPerBlock(), in_dim.getColsPerBlock(), in_dim.getNonZeros());
        } else if (ins instanceof RandInstruction || ins instanceof SeqInstruction) {
            DataGenMRInstruction dataIns = (DataGenMRInstruction)ins;
            dimOut.set(dims.get(dataIns.getInput()));
        } else if (ins instanceof ReplicateInstruction) {
            ReplicateInstruction realIns = (ReplicateInstruction)ins;
            realIns.computeOutputDimension(dims.get(realIns.input), dimOut);
        } else if (ins instanceof ParameterizedBuiltinMRInstruction) {
            ParameterizedBuiltinMRInstruction realIns = (ParameterizedBuiltinMRInstruction)ins;
            realIns.computeOutputCharacteristics(dims.get(realIns.input), dimOut);
        } else if (ins instanceof ScalarInstruction || ins instanceof AggregateInstruction || ins instanceof UnaryInstruction && !(ins instanceof MMTSJMRInstruction) || ins instanceof ZeroOutInstruction) {
            UnaryMRInstructionBase realIns = (UnaryMRInstructionBase)ins;
            dimOut.set(dims.get(realIns.input));
        } else if (ins instanceof MMTSJMRInstruction) {
            MMTSJMRInstruction mmtsj = (MMTSJMRInstruction)ins;
            MMTSJ.MMTSJType tstype = mmtsj.getMMTSJType();
            MatrixCharacteristics mc = dims.get(mmtsj.input);
            dimOut.set(tstype.isLeft() ? mc.numColumns : mc.numRows, tstype.isLeft() ? mc.numColumns : mc.numRows, mc.numRowsPerBlock, mc.numColumnsPerBlock);
        } else if (ins instanceof PMMJMRInstruction) {
            PMMJMRInstruction pmmins = (PMMJMRInstruction)ins;
            MatrixCharacteristics mc = dims.get(pmmins.input2);
            dimOut.set(pmmins.getNumRows(), mc.numColumns, mc.numRowsPerBlock, mc.numColumnsPerBlock);
        } else if (ins instanceof RemoveEmptyMRInstruction) {
            long min;
            RemoveEmptyMRInstruction realIns = (RemoveEmptyMRInstruction)ins;
            MatrixCharacteristics mc = dims.get(realIns.input1);
            long l = min = realIns.isEmptyReturn() ? 1L : 0L;
            if (realIns.isRemoveRows()) {
                dimOut.set(Math.max(realIns.getOutputLen(), min), mc.getCols(), mc.numRowsPerBlock, mc.numColumnsPerBlock);
            } else {
                dimOut.set(mc.getRows(), Math.max(realIns.getOutputLen(), min), mc.numRowsPerBlock, mc.numColumnsPerBlock);
            }
        } else if (ins instanceof UaggOuterChainInstruction) {
            UaggOuterChainInstruction realIns = (UaggOuterChainInstruction)ins;
            MatrixCharacteristics mc1 = dims.get(realIns.input1);
            MatrixCharacteristics mc2 = dims.get(realIns.input2);
            realIns.computeOutputCharacteristics(mc1, mc2, dimOut);
        } else if (ins instanceof GroupedAggregateMInstruction) {
            GroupedAggregateMInstruction realIns = (GroupedAggregateMInstruction)ins;
            MatrixCharacteristics mc1 = dims.get(realIns.input1);
            realIns.computeOutputCharacteristics(mc1, dimOut);
        } else if (ins instanceof BinaryInstruction || ins instanceof BinaryMInstruction || ins instanceof CombineBinaryInstruction) {
            BinaryMRInstructionBase realIns = (BinaryMRInstructionBase)ins;
            MatrixCharacteristics mc1 = dims.get(realIns.input1);
            MatrixCharacteristics mc2 = dims.get(realIns.input2);
            if (mc1.getRows() > 1L && mc1.getCols() == 1L && mc2.getRows() == 1L && mc2.getCols() > 1L) {
                dimOut.set(mc1.getRows(), mc2.getCols(), mc1.getRowsPerBlock(), mc2.getColsPerBlock());
            } else {
                dimOut.set(mc1);
            }
        } else if (ins instanceof TernaryInstruction) {
            dimOut.set(dims.get(ins.getInputIndexes()[0]));
        } else if (ins instanceof CombineTernaryInstruction) {
            CtableInstruction realIns = (CtableInstruction)ins;
            dimOut.set(dims.get(realIns.input1));
        } else if (ins instanceof CombineUnaryInstruction) {
            dimOut.set(dims.get(((CombineUnaryInstruction)ins).input));
        } else if (ins instanceof CM_N_COVInstruction || ins instanceof GroupedAggregateInstruction) {
            dimOut.set(1L, 1L, 1, 1);
        } else if (ins instanceof RangeBasedReIndexInstruction) {
            RangeBasedReIndexInstruction realIns = (RangeBasedReIndexInstruction)ins;
            MatrixCharacteristics dimIn = dims.get(realIns.input);
            realIns.computeOutputCharacteristics(dimIn, dimOut);
        } else if (ins instanceof CtableInstruction) {
            CtableInstruction realIns = (CtableInstruction)ins;
            MatrixCharacteristics in_dim = dims.get(realIns.input1);
            dimOut.set(realIns.getOutputDim1(), realIns.getOutputDim2(), in_dim.numRowsPerBlock, in_dim.numColumnsPerBlock);
        } else {
            dimOut.numRows = -1L;
            dimOut.numColumns = -1L;
            dimOut.numRowsPerBlock = 1;
            dimOut.numColumnsPerBlock = 1;
        }
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof MatrixCharacteristics)) {
            return false;
        }
        MatrixCharacteristics mc = (MatrixCharacteristics)anObject;
        return this.numRows == mc.numRows && this.numColumns == mc.numColumns && this.numRowsPerBlock == mc.numRowsPerBlock && this.numColumnsPerBlock == mc.numColumnsPerBlock && this.nonZero == mc.nonZero;
    }

    public int hashCode() {
        return Arrays.hashCode(new long[]{this.numRows, this.numColumns, this.numRowsPerBlock, this.numColumnsPerBlock, this.nonZero});
    }
}

