/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.estim;

import org.apache.commons.lang.NotImplementedException;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.estim.MMNode;
import org.apache.sysml.hops.estim.SparsityEstimator;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public class EstimatorBasicWorst
extends SparsityEstimator {
    @Override
    public MatrixCharacteristics estim(MMNode root) {
        MatrixCharacteristics mc1 = !root.getLeft().isLeaf() ? this.estim(root.getLeft()) : root.getLeft().getMatrixCharacteristics();
        MatrixCharacteristics mc2 = !root.getRight().isLeaf() ? this.estim(root.getRight()) : root.getRight().getMatrixCharacteristics();
        return root.setMatrixCharacteristics(this.estimIntern(mc1, mc2, root.getOp()));
    }

    @Override
    public double estim(MatrixBlock m1, MatrixBlock m2) {
        return this.estim(m1, m2, SparsityEstimator.OpCode.MM);
    }

    @Override
    public double estim(MatrixBlock m1, MatrixBlock m2, SparsityEstimator.OpCode op) {
        return this.estimIntern(m1.getMatrixCharacteristics(), m2.getMatrixCharacteristics(), op).getSparsity();
    }

    @Override
    public double estim(MatrixBlock m, SparsityEstimator.OpCode op) {
        return this.estimIntern(m.getMatrixCharacteristics(), null, op).getSparsity();
    }

    private MatrixCharacteristics estimIntern(MatrixCharacteristics mc1, MatrixCharacteristics mc2, SparsityEstimator.OpCode op) {
        switch (op) {
            case MM: {
                return new MatrixCharacteristics(mc1.getRows(), mc2.getCols(), OptimizerUtils.getMatMultNnz(mc1.getSparsity(), mc2.getSparsity(), mc1.getRows(), mc1.getCols(), mc2.getCols(), true));
            }
            case MULT: {
                return new MatrixCharacteristics(mc1.getRows(), mc1.getCols(), OptimizerUtils.getNnz(mc1.getRows(), mc1.getCols(), Math.min(mc1.getSparsity(), mc2.getSparsity())));
            }
            case PLUS: {
                return new MatrixCharacteristics(mc1.getRows(), mc1.getCols(), OptimizerUtils.getNnz(mc1.getRows(), mc1.getCols(), Math.min(mc1.getSparsity() + mc2.getSparsity(), 1.0)));
            }
            case EQZERO: 
            case DIAG: 
            case CBIND: 
            case RBIND: 
            case NEQZERO: 
            case TRANS: 
            case RESHAPE: {
                return this.estimExactMetaData(mc1, mc2, op);
            }
        }
        throw new NotImplementedException();
    }
}

