/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.functionobjects.OffsetColumnIndex;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.AppendCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.ReorgOperator;
import org.apache.sysml.utils.GPUStatistics;

public class MatrixAppendGPUInstruction
extends GPUInstruction {
    CPOperand output;
    CPOperand input1;
    CPOperand input2;
    AppendCPInstruction.AppendType atype;

    private MatrixAppendGPUInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, AppendCPInstruction.AppendType type, String opcode, String istr) {
        super(op, opcode, istr);
        this.output = out;
        this.input1 = in1;
        this.input2 = in2;
        this.atype = type;
    }

    public static MatrixAppendGPUInstruction parseInstruction(String str) {
        AppendCPInstruction.AppendType type;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[4]);
        boolean cbind = Boolean.parseBoolean(parts[5]);
        AppendCPInstruction.AppendType appendType = in1.getDataType() != Expression.DataType.MATRIX && in1.getDataType() != Expression.DataType.FRAME ? AppendCPInstruction.AppendType.STRING : (type = cbind ? AppendCPInstruction.AppendType.CBIND : AppendCPInstruction.AppendType.RBIND);
        if (in1.getDataType() != Expression.DataType.MATRIX || in2.getDataType() != Expression.DataType.MATRIX) {
            throw new DMLRuntimeException("GPU : Error in internal state - Append was called on data other than matrices");
        }
        if (!opcode.equalsIgnoreCase("append")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a AppendCPInstruction: " + str);
        }
        ReorgOperator op = new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1));
        return new MatrixAppendGPUInstruction(op, in1, in2, out, type, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        String opcode = this.getOpcode();
        MatrixObject mat1 = this.getMatrixInputForGPUInstruction(ec, this.input1.getName());
        MatrixObject mat2 = this.getMatrixInputForGPUInstruction(ec, this.input2.getName());
        if (this.atype == AppendCPInstruction.AppendType.CBIND) {
            LibMatrixCUDA.cbind(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat1, mat2, this.output.getName());
        } else if (this.atype == AppendCPInstruction.AppendType.RBIND) {
            LibMatrixCUDA.rbind(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat1, mat2, this.output.getName());
        } else {
            throw new DMLRuntimeException("Unsupported GPU operator:" + opcode);
        }
        ec.releaseMatrixInputForGPUInstruction(this.input1.getName());
        ec.releaseMatrixInputForGPUInstruction(this.input2.getName());
        ec.releaseMatrixOutputForGPUInstruction(this.output.getName());
    }
}

