/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data.hadoopfix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sysml.runtime.matrix.data.hadoopfix.MultipleInputs;
import org.apache.sysml.runtime.matrix.data.hadoopfix.TaggedInputSplit;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;

public class DelegatingInputFormat<K, V>
implements InputFormat<K, V> {
    public InputSplit[] getSplits(JobConf conf, int numSplits) throws IOException {
        JobConf confCopy = new JobConf((Configuration)conf);
        ArrayList<TaggedInputSplit> splits = new ArrayList<TaggedInputSplit>();
        Map<Path, InputFormat> formatMap = MultipleInputs.getInputFormatMap(conf);
        Map<Path, Class<? extends Mapper>> mapperMap = MultipleInputs.getMapperTypeMap(conf);
        HashMap formatPaths = new HashMap();
        for (Map.Entry<Path, InputFormat> entry : formatMap.entrySet()) {
            if (!formatPaths.containsKey(entry.getValue().getClass())) {
                formatPaths.put(entry.getValue().getClass(), new LinkedList());
            }
            ((List)formatPaths.get(entry.getValue().getClass())).add(entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : formatPaths.entrySet()) {
            Class mapperClass;
            Class formatClass = (Class)entry.getKey();
            InputFormat format = (InputFormat)ReflectionUtils.newInstance((Class)formatClass, (Configuration)conf);
            List paths = (List)entry.getValue();
            HashMap mapperPaths = new HashMap();
            for (Path path : paths) {
                mapperClass = mapperMap.get(path);
                if (!mapperPaths.containsKey(mapperClass)) {
                    mapperPaths.put(mapperClass, new LinkedList());
                }
                ((List)mapperPaths.get(mapperClass)).add(path);
            }
            for (Map.Entry entry2 : mapperPaths.entrySet()) {
                InputSplit[] pathSplits;
                paths = (List)entry2.getValue();
                mapperClass = (Class)entry2.getKey();
                if (mapperClass == null) {
                    mapperClass = conf.getMapperClass();
                }
                FileInputFormat.setInputPaths((JobConf)confCopy, (Path[])paths.toArray(new Path[paths.size()]));
                for (InputSplit pathSplit : pathSplits = format.getSplits(confCopy, numSplits)) {
                    splits.add(new TaggedInputSplit(pathSplit, (Configuration)conf, format.getClass(), mapperClass));
                }
            }
        }
        return splits.toArray(new InputSplit[splits.size()]);
    }

    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        TaggedInputSplit taggedInputSplit = (TaggedInputSplit)split;
        InputFormat inputFormat = (InputFormat)ReflectionUtils.newInstance(taggedInputSplit.getInputFormatClass(), (Configuration)conf);
        InputSplit inputSplit = taggedInputSplit.getInputSplit();
        if (inputSplit instanceof FileSplit) {
            FileSplit fileSplit = (FileSplit)inputSplit;
            conf.set(MRConfigurationNames.MR_MAP_INPUT_FILE, fileSplit.getPath().toString());
            conf.setLong(MRConfigurationNames.MR_MAP_INPUT_START, fileSplit.getStart());
            conf.setLong(MRConfigurationNames.MR_MAP_INPUT_LENGTH, fileSplit.getLength());
        }
        return inputFormat.getRecordReader(taggedInputSplit.getInputSplit(), conf, reporter);
    }
}

