/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.sort;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileRecordReader;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.QuickSort;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.Converter;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;

public class SamplingSortMRInputFormat<K extends WritableComparable, V extends Writable>
extends SequenceFileInputFormat<K, V> {
    public static final String PARTITION_FILENAME = "_partition.lst";
    static final String SAMPLE_SIZE = "sort.partitions.sample";
    private static JobConf lastConf = null;
    private static InputSplit[] lastResult = null;
    public static final String TARGET_KEY_CLASS = "target.key.class";
    public static final String TARGET_VALUE_CLASS = "target.value.class";

    public static void setTargetKeyValueClasses(JobConf job, Class<? extends WritableComparable> keyClass, Class<? extends Writable> valueClass) {
        job.setClass(TARGET_KEY_CLASS, keyClass, WritableComparable.class);
        job.setClass(TARGET_VALUE_CLASS, valueClass, Writable.class);
    }

    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        if (reporter != null) {
            reporter.setStatus(split.toString());
        }
        return new SequenceFileRecordReader((Configuration)job, (FileSplit)split);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writePartitionFile(JobConf conf, Path partFile) throws IOException, InstantiationException, IllegalAccessException {
        FileSystem outFs;
        SamplingSortMRInputFormat inFormat = new SamplingSortMRInputFormat();
        Sampler sampler = new Sampler();
        Class targetKeyClass = conf.getClass(TARGET_KEY_CLASS, WritableComparable.class);
        int brlen = MRJobConfiguration.getNumRowsPerBlock(conf, (byte)0);
        int bclen = MRJobConfiguration.getNumColumnsPerBlock(conf, (byte)0);
        int partitions = conf.getNumReduceTasks();
        long sampleSize = conf.getLong(SAMPLE_SIZE, 1000L);
        InputSplit[] splits = inFormat.getSplits(conf, conf.getNumMapTasks());
        int samples = Math.min(10, splits.length);
        long recordsPerSample = sampleSize / (long)samples;
        int sampleStep = splits.length / samples;
        int totalcount = 0;
        for (int i = 0; i < samples; ++i) {
            SequenceFileRecordReader reader = (SequenceFileRecordReader)inFormat.getRecordReader(splits[sampleStep * i], conf, null);
            int count = 0;
            WritableComparable key = (WritableComparable)reader.createKey();
            Writable value = (Writable)reader.createValue();
            while (reader.next((Object)key, (Object)value) && (long)count < recordsPerSample) {
                Converter inputConverter = MRJobConfiguration.getInputConverter(conf, (byte)0);
                inputConverter.setBlockSize(brlen, bclen);
                inputConverter.convert(key, value);
                while (inputConverter.hasNext()) {
                    Pair pair = inputConverter.next();
                    if (pair.getKey() instanceof DoubleWritable) {
                        sampler.addValue((WritableComparable)new DoubleWritable(((DoubleWritable)pair.getKey()).get()));
                    } else if (pair.getValue() instanceof MatrixCell) {
                        sampler.addValue((WritableComparable)new DoubleWritable(((MatrixCell)pair.getValue()).getValue()));
                    } else {
                        throw new IOException("SamplingSortMRInputFormat unsupported key/value class: " + pair.getKey().getClass() + ":" + pair.getValue().getClass());
                    }
                    ++count;
                }
                key = (WritableComparable)reader.createKey();
                value = (Writable)reader.createValue();
            }
            totalcount += count;
        }
        if (totalcount == 0) {
            sampler.addValue((WritableComparable)new DoubleWritable(0.0));
        }
        if ((outFs = partFile.getFileSystem((Configuration)conf)).exists(partFile)) {
            outFs.delete(partFile, false);
        }
        SequenceFile.Writer writer = null;
        int index0 = -1;
        try {
            writer = SequenceFile.createWriter((FileSystem)outFs, (Configuration)conf, (Path)partFile, DoubleWritable.class, NullWritable.class);
            NullWritable nullValue = NullWritable.get();
            int i = 0;
            boolean lessthan0 = true;
            for (WritableComparable splitValue : sampler.createPartitions(partitions)) {
                writer.append((Writable)splitValue, (Writable)nullValue);
                if (lessthan0 && ((DoubleWritable)splitValue).get() >= 0.0) {
                    index0 = i;
                    lessthan0 = false;
                }
                ++i;
            }
            if (lessthan0) {
                index0 = partitions - 1;
            }
        }
        catch (Throwable throwable) {
            IOUtilFunctions.closeSilently(writer);
            throw throwable;
        }
        IOUtilFunctions.closeSilently((Closeable)writer);
        return index0;
    }

    public InputSplit[] getSplits(JobConf conf, int splits) throws IOException {
        if (conf == lastConf) {
            return lastResult;
        }
        lastConf = conf;
        lastResult = super.getSplits(conf, splits);
        return lastResult;
    }

    private static class Sampler
    implements IndexedSortable {
        private ArrayList<WritableComparable> records = new ArrayList();

        private Sampler() {
        }

        public int compare(int i, int j) {
            WritableComparable left = this.records.get(i);
            WritableComparable right = this.records.get(j);
            return left.compareTo((Object)right);
        }

        public void swap(int i, int j) {
            WritableComparable left = this.records.get(i);
            WritableComparable right = this.records.get(j);
            this.records.set(j, left);
            this.records.set(i, right);
        }

        public void addValue(WritableComparable r) {
            this.records.add(r);
        }

        public String toString() {
            return this.records.toString();
        }

        public ArrayList<WritableComparable> createPartitions(int numPartitions) {
            int numRecords = this.records.size();
            if (numPartitions > numRecords) {
                throw new IllegalArgumentException("Requested more partitions than input keys (" + numPartitions + " > " + numRecords + ")");
            }
            new QuickSort().sort((IndexedSortable)this, 0, this.records.size());
            float stepSize = (float)numRecords / (float)numPartitions;
            ArrayList<WritableComparable> result = new ArrayList<WritableComparable>(numPartitions - 1);
            for (int i = 1; i < numPartitions; ++i) {
                result.add(this.records.get(Math.round(stepSize * (float)i)));
            }
            return result;
        }
    }
}

