/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.encode;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class EncoderBin
extends Encoder {
    private static final long serialVersionUID = 1917445005206076078L;
    public static final String MIN_PREFIX = "min";
    public static final String MAX_PREFIX = "max";
    public static final String NBINS_PREFIX = "nbins";
    private int[] _numBins = null;
    private double[] _min = null;
    private double[] _max = null;
    private double[][] _binMins = null;
    private double[][] _binMaxs = null;

    public EncoderBin(JSONObject parsedSpec, String[] colnames, int clen) throws JSONException, IOException {
        this(parsedSpec, colnames, clen, false);
    }

    public EncoderBin(JSONObject parsedSpec, String[] colnames, int clen, boolean colsOnly) throws JSONException, IOException {
        super(null, clen);
        if (!parsedSpec.containsKey("bin")) {
            return;
        }
        if (colsOnly) {
            List<Integer> collist = TfMetaUtils.parseBinningColIDs(parsedSpec, colnames);
            this.initColList(ArrayUtils.toPrimitive((Integer[])collist.toArray(new Integer[0])));
        } else {
            JSONObject obj = (JSONObject)parsedSpec.get("bin");
            JSONArray attrs = (JSONArray)obj.get("attributes");
            JSONArray nbins = (JSONArray)obj.get("numbins");
            this.initColList(attrs);
            this._numBins = new int[attrs.size()];
            for (int i = 0; i < this._numBins.length; ++i) {
                this._numBins[i] = UtilFunctions.toInt(nbins.get(i));
            }
            this._min = new double[this._colList.length];
            Arrays.fill(this._min, Double.POSITIVE_INFINITY);
            this._max = new double[this._colList.length];
            Arrays.fill(this._max, Double.NEGATIVE_INFINITY);
        }
    }

    public void prepare(String[] words, TfUtils agents) {
        if (!this.isApplicable()) {
            return;
        }
        for (int i = 0; i < this._colList.length; ++i) {
            int colID = this._colList[i];
            String w = null;
            double d = 0.0;
            w = UtilFunctions.unquote(words[colID - 1].trim());
            if (TfUtils.isNA(agents.getNAStrings(), w)) continue;
            d = UtilFunctions.parseToDouble(w);
            if (d < this._min[i]) {
                this._min[i] = d;
            }
            if (!(d > this._max[i])) continue;
            this._max[i] = d;
        }
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        this.build(in);
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            for (int i = 0; i < in.getNumRows(); ++i) {
                double inVal = UtilFunctions.objectToDouble(in.getSchema()[colID - 1], in.get(i, colID - 1));
                int ix = Arrays.binarySearch(this._binMaxs[j], inVal);
                int binID = (ix < 0 ? Math.abs(ix + 1) : ix) + 1;
                out.quickSetValue(i, colID - 1, binID);
            }
        }
        return out;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._binMins = new double[this._colList.length][];
        this._binMaxs = new double[this._colList.length][];
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            int nbins = (int)meta.getColumnMetadata()[colID - 1].getNumDistinct();
            this._binMins[j] = new double[nbins];
            this._binMaxs[j] = new double[nbins];
            for (int i = 0; i < nbins; ++i) {
                String[] tmp = meta.get(i, colID - 1).toString().split("\u00b7");
                this._binMins[j][i] = Double.parseDouble(tmp[0]);
                this._binMaxs[j][i] = Double.parseDouble(tmp[1]);
            }
        }
    }
}

