/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.udf.lib;

import org.apache.sysml.udf.FunctionParameter;
import org.apache.sysml.udf.Matrix;
import org.apache.sysml.udf.PackageFunction;
import org.apache.sysml.udf.Scalar;

public class BinningWrapper
extends PackageFunction {
    private static final long serialVersionUID = 1L;
    private static final String OUTPUT_FILE = "TMP";
    private Matrix _bins;
    private Scalar _defBins;

    @Override
    public int getNumFunctionOutputs() {
        return 2;
    }

    @Override
    public FunctionParameter getFunctionOutput(int pos) {
        switch (pos) {
            case 0: {
                return this._bins;
            }
            case 1: {
                return this._defBins;
            }
        }
        throw new RuntimeException("Invalid function output being requested");
    }

    @Override
    public void execute() {
        try {
            int bin_id;
            Matrix inM = (Matrix)this.getFunctionInput(0);
            double[][] col = inM.getMatrixAsDoubleArray();
            int binsize = Integer.parseInt(((Scalar)this.getFunctionInput(1)).getValue());
            int numbins = Integer.parseInt(((Scalar)this.getFunctionInput(2)).getValue());
            int nrowX = (int)inM.getNumRows();
            double[] col_bins = new double[numbins + 1];
            int pos_col = 0;
            col_bins[0] = col[0][0];
            for (bin_id = 0; pos_col < nrowX - 1 && bin_id < numbins; ++bin_id) {
                double end_val;
                pos_col = pos_col + binsize >= nrowX ? nrowX - 1 : pos_col + binsize;
                col_bins[bin_id + 1] = end_val = col[pos_col][0];
                boolean cont = true;
                while (cont && pos_col < nrowX - 1) {
                    if (end_val == col[pos_col + 1][0]) {
                        ++pos_col;
                        continue;
                    }
                    cont = false;
                }
            }
            int num_bins_defined = bin_id;
            for (int i = 0; i < num_bins_defined; ++i) {
                col_bins[i] = (col_bins[i] + col_bins[i + 1]) / 2.0;
            }
            String dir = this.createOutputFilePathAndName(OUTPUT_FILE);
            this._bins = new Matrix(dir, col_bins.length, 1L, Matrix.ValueType.Double);
            this._bins.setMatrixDoubleArray(col_bins);
            this._defBins = new Scalar(Scalar.ScalarValueType.Integer, String.valueOf(num_bins_defined));
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing external order function", e);
        }
    }
}

