/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.nativeio;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.HardLink;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.io.nativeio.Errno;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.io.nativeio.NativeIOException;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.PerformanceAdvisory;
import org.apache.hadoop.util.Shell;
import sun.misc.Unsafe;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NativeIO {
    private static boolean workaroundNonThreadSafePasswdCalls = false;
    private static final Log LOG = LogFactory.getLog(NativeIO.class);
    private static boolean nativeLoaded = false;
    private static final Map<Long, CachedUid> uidCache;
    private static long cacheTimeout;
    private static boolean initialized;

    public static boolean isAvailable() {
        return NativeCodeLoader.isNativeCodeLoaded() && nativeLoaded;
    }

    private static native void initNative();

    static long getMemlockLimit() {
        return NativeIO.isAvailable() ? NativeIO.getMemlockLimit0() : 0L;
    }

    private static native long getMemlockLimit0();

    static long getOperatingSystemPageSize() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Unsafe unsafe = (Unsafe)f.get(null);
            return unsafe.pageSize();
        }
        catch (Throwable e) {
            LOG.warn("Unable to get operating system page size.  Guessing 4096.", e);
            return 4096L;
        }
    }

    private static String stripDomain(String name) {
        int i = name.indexOf(92);
        if (i != -1) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public static String getOwner(FileDescriptor fd) throws IOException {
        NativeIO.ensureInitialized();
        if (Shell.WINDOWS) {
            String owner = Windows.access$900((FileDescriptor)fd);
            owner = NativeIO.stripDomain(owner);
            return owner;
        }
        long uid = POSIX.access$1000((FileDescriptor)fd);
        CachedUid cUid = uidCache.get(uid);
        long now = System.currentTimeMillis();
        if (cUid != null && cUid.timestamp + cacheTimeout > now) {
            return cUid.username;
        }
        String user = POSIX.access$1100((long)uid);
        LOG.info("Got UserName " + user + " for UID " + uid + " from the native implementation");
        cUid = new CachedUid(user, now);
        uidCache.put(uid, cUid);
        return user;
    }

    public static FileInputStream getShareDeleteFileInputStream(File f) throws IOException {
        if (!Shell.WINDOWS) {
            return new FileInputStream(f);
        }
        FileDescriptor fd = Windows.createFile((String)f.getAbsolutePath(), (long)0x80000000L, (long)7L, (long)3L);
        return new FileInputStream(fd);
    }

    public static FileInputStream getShareDeleteFileInputStream(File f, long seekOffset) throws IOException {
        if (!Shell.WINDOWS) {
            RandomAccessFile rf = new RandomAccessFile(f, "r");
            if (seekOffset > 0L) {
                rf.seek(seekOffset);
            }
            return new FileInputStream(rf.getFD());
        }
        FileDescriptor fd = Windows.createFile((String)f.getAbsolutePath(), (long)0x80000000L, (long)7L, (long)3L);
        if (seekOffset > 0L) {
            Windows.setFilePointer((FileDescriptor)fd, (long)seekOffset, (long)0L);
        }
        return new FileInputStream(fd);
    }

    public static FileOutputStream getCreateForWriteFileOutputStream(File f, int permissions) throws IOException {
        if (!Shell.WINDOWS) {
            try {
                FileDescriptor fd = POSIX.open((String)f.getAbsolutePath(), (int)193, (int)permissions);
                return new FileOutputStream(fd);
            }
            catch (NativeIOException nioe) {
                if (nioe.getErrno() == Errno.EEXIST) {
                    throw new SecureIOUtils.AlreadyExistsException(nioe);
                }
                throw nioe;
            }
        }
        try {
            FileDescriptor fd = Windows.createFile((String)f.getCanonicalPath(), (long)0x40000000L, (long)7L, (long)1L);
            POSIX.chmod((String)f.getCanonicalPath(), (int)permissions);
            return new FileOutputStream(fd);
        }
        catch (NativeIOException nioe) {
            if (nioe.getErrorCode() == 80L) {
                throw new SecureIOUtils.AlreadyExistsException(nioe);
            }
            throw nioe;
        }
    }

    private static synchronized void ensureInitialized() {
        if (!initialized) {
            cacheTimeout = new Configuration().getLong("hadoop.security.uid.cache.secs", 14400L) * 1000L;
            LOG.info("Initialized cache for UID to User mapping with a cache timeout of " + cacheTimeout / 1000L + " seconds.");
            initialized = true;
        }
    }

    public static void renameTo(File src, File dst) throws IOException {
        if (!nativeLoaded) {
            if (!src.renameTo(dst)) {
                throw new IOException("renameTo(src=" + src + ", dst=" + dst + ") failed.");
            }
        } else {
            NativeIO.renameTo0(src.getAbsolutePath(), dst.getAbsolutePath());
        }
    }

    public static void link(File src, File dst) throws IOException {
        if (!nativeLoaded) {
            HardLink.createHardLink((File)src, (File)dst);
        } else {
            NativeIO.link0(src.getAbsolutePath(), dst.getAbsolutePath());
        }
    }

    private static native void renameTo0(String var0, String var1) throws NativeIOException;

    private static native void link0(String var0, String var1) throws NativeIOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFileUnbuffered(File src, File dst) throws IOException {
        if (nativeLoaded && Shell.WINDOWS) {
            NativeIO.copyFileUnbuffered0(src.getAbsolutePath(), dst.getAbsolutePath());
            return;
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dst);
            input = fis.getChannel();
            output = fos.getChannel();
            long position = 0L;
            long transferred = 0L;
            for (long remaining = input.size(); remaining > 0L; remaining -= transferred, position += transferred) {
                transferred = input.transferTo(position, remaining, output);
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, output);
            IOUtils.cleanup(LOG, fos);
            IOUtils.cleanup(LOG, input);
            IOUtils.cleanup(LOG, fis);
            throw throwable;
        }
        IOUtils.cleanup(LOG, output);
        IOUtils.cleanup(LOG, fos);
        IOUtils.cleanup(LOG, input);
        IOUtils.cleanup(LOG, fis);
    }

    private static native void copyFileUnbuffered0(String var0, String var1) throws NativeIOException;

    static /* synthetic */ boolean access$102(boolean x0) {
        workaroundNonThreadSafePasswdCalls = x0;
        return workaroundNonThreadSafePasswdCalls;
    }

    static /* synthetic */ void access$200() {
        NativeIO.initNative();
    }

    static /* synthetic */ String access$300(String x0) {
        return NativeIO.stripDomain(x0);
    }

    static /* synthetic */ boolean access$802(boolean x0) {
        nativeLoaded = x0;
        return nativeLoaded;
    }

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                NativeIO.initNative();
                nativeLoaded = true;
            }
            catch (Throwable t) {
                PerformanceAdvisory.LOG.debug("Unable to initialize NativeIO libraries", t);
            }
        }
        uidCache = new ConcurrentHashMap<Long, CachedUid>();
        initialized = false;
    }
}

