/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.debug.DMLFrame;
import org.apache.sysml.debug.DMLProgramCounter;
import org.apache.sysml.debug.DebugState;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ListObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysml.runtime.instructions.gpu.context.GPUContext;
import org.apache.sysml.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaData;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.utils.GPUStatistics;
import org.apache.sysml.utils.Statistics;

public class ExecutionContext {
    protected static final Log LOG = LogFactory.getLog(ExecutionContext.class.getName());
    protected Program _prog = null;
    protected LocalVariableMap _variables;
    protected DebugState _dbState = null;
    protected List<GPUContext> _gpuContexts = new ArrayList<GPUContext>();

    protected ExecutionContext() {
        this(true, null);
    }

    protected ExecutionContext(boolean allocateVariableMap, Program prog) {
        this._variables = allocateVariableMap ? new LocalVariableMap() : null;
        this._prog = prog;
        if (DMLScript.ENABLE_DEBUG_MODE) {
            this._dbState = DebugState.getInstance();
        }
    }

    public Program getProgram() {
        return this._prog;
    }

    public void setProgram(Program prog) {
        this._prog = prog;
    }

    public LocalVariableMap getVariables() {
        return this._variables;
    }

    public void setVariables(LocalVariableMap vars) {
        this._variables = vars;
    }

    public GPUContext getGPUContext(int index) {
        try {
            return this._gpuContexts.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setGPUContexts(List<GPUContext> gpuContexts) {
        this._gpuContexts = gpuContexts;
    }

    public List<GPUContext> getGPUContexts() {
        return this._gpuContexts;
    }

    public int getNumGPUContexts() {
        return this._gpuContexts.size();
    }

    public Data getVariable(String name) {
        return this._variables.get(name);
    }

    public Data getVariable(CPOperand operand) {
        return operand.getDataType().isScalar() ? this.getScalarInput(operand) : this.getVariable(operand.getName());
    }

    public void setVariable(String name, Data val) {
        this._variables.put(name, val);
    }

    public boolean containsVariable(String name) {
        return this._variables.keySet().contains(name);
    }

    public Data removeVariable(String name) {
        return this._variables.remove(name);
    }

    public void setMetaData(String fname, MetaData md) {
        this._variables.get(fname).setMetaData(md);
    }

    public MetaData getMetaData(String varname) {
        return this._variables.get(varname).getMetaData();
    }

    public boolean isMatrixObject(String varname) {
        Data dat = this.getVariable(varname);
        return dat != null && dat instanceof MatrixObject;
    }

    public MatrixObject getMatrixObject(CPOperand input) {
        return this.getMatrixObject(input.getName());
    }

    public MatrixObject getMatrixObject(String varname) {
        Data dat = this.getVariable(varname);
        if (dat == null) {
            throw new DMLRuntimeException("Variable '" + varname + "' does not exist in the symbol table.");
        }
        if (!(dat instanceof MatrixObject)) {
            throw new DMLRuntimeException("Variable '" + varname + "' is not a matrix.");
        }
        return (MatrixObject)dat;
    }

    public boolean isFrameObject(String varname) {
        Data dat = this.getVariable(varname);
        return dat != null && dat instanceof FrameObject;
    }

    public FrameObject getFrameObject(CPOperand input) {
        return this.getFrameObject(input.getName());
    }

    public FrameObject getFrameObject(String varname) {
        Data dat = this.getVariable(varname);
        if (dat == null) {
            throw new DMLRuntimeException("Variable '" + varname + "' does not exist in the symbol table.");
        }
        if (!(dat instanceof FrameObject)) {
            throw new DMLRuntimeException("Variable '" + varname + "' is not a frame.");
        }
        return (FrameObject)dat;
    }

    public CacheableData<?> getCacheableData(CPOperand input) {
        return this.getCacheableData(input.getName());
    }

    public CacheableData<?> getCacheableData(String varname) {
        Data dat = this.getVariable(varname);
        if (dat == null) {
            throw new DMLRuntimeException("Variable '" + varname + "' does not exist in the symbol table.");
        }
        if (!(dat instanceof CacheableData)) {
            throw new DMLRuntimeException("Variable '" + varname + "' is not a matrix or frame.");
        }
        return (CacheableData)dat;
    }

    public void releaseCacheableData(String varname) {
        CacheableData<?> dat = this.getCacheableData(varname);
        dat.release();
    }

    public MatrixCharacteristics getMatrixCharacteristics(String varname) {
        return this.getMetaData(varname).getMatrixCharacteristics();
    }

    public MatrixBlock getMatrixInput(String varName, String opcode) {
        long t1 = opcode != null && DMLScript.STATISTICS && DMLScript.FINEGRAINED_STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock mb = this.getMatrixInput(varName);
        if (opcode != null && DMLScript.STATISTICS && DMLScript.FINEGRAINED_STATISTICS) {
            long t2 = System.nanoTime();
            if (mb.isInSparseFormat()) {
                GPUStatistics.maintainCPMiscTimes(opcode, "aqrs", t2 - t1);
            } else {
                GPUStatistics.maintainCPMiscTimes(opcode, "aqrd", t2 - t1);
            }
        }
        return mb;
    }

    public MatrixBlock getMatrixInput(String varName) {
        MatrixObject mo = this.getMatrixObject(varName);
        return (MatrixBlock)mo.acquireRead();
    }

    public void setMetaData(String varName, long nrows, long ncols) {
        MatrixObject mo = this.getMatrixObject(varName);
        if (mo.getNumRows() == nrows && mo.getNumColumns() == ncols) {
            return;
        }
        MetaData oldMetaData = mo.getMetaData();
        if (oldMetaData == null || !(oldMetaData instanceof MetaDataFormat)) {
            throw new DMLRuntimeException("Metadata not available");
        }
        MatrixCharacteristics mc = new MatrixCharacteristics(nrows, ncols, (int)mo.getNumRowsPerBlock(), (int)mo.getNumColumnsPerBlock());
        mo.setMetaData(new MetaDataFormat(mc, ((MetaDataFormat)oldMetaData).getOutputInfo(), ((MetaDataFormat)oldMetaData).getInputInfo()));
    }

    private static long validateDimensions(long d1, long d2) {
        if (d1 >= 0L && d2 >= 0L && d1 != d2) {
            throw new DMLRuntimeException("Incorrect dimensions:" + d1 + " != " + d2);
        }
        return Math.max(d1, d2);
    }

    public Pair<MatrixObject, Boolean> getDenseMatrixOutputForGPUInstruction(String varName, long numRows, long numCols) {
        MatrixObject mo = this.allocateGPUMatrixObject(varName, numRows, numCols);
        boolean allocated = mo.getGPUObject(this.getGPUContext(0)).acquireDeviceModifyDense();
        mo.getMatrixCharacteristics().setNonZeros(-1L);
        return new Pair<MatrixObject, Boolean>(mo, allocated);
    }

    public Pair<MatrixObject, Boolean> getSparseMatrixOutputForGPUInstruction(String varName, long numRows, long numCols, long nnz) {
        MatrixObject mo = this.allocateGPUMatrixObject(varName, numRows, numCols);
        mo.getMatrixCharacteristics().setNonZeros(nnz);
        boolean allocated = mo.getGPUObject(this.getGPUContext(0)).acquireDeviceModifySparse();
        return new Pair<MatrixObject, Boolean>(mo, allocated);
    }

    public MatrixObject allocateGPUMatrixObject(String varName, long numRows, long numCols) {
        MatrixObject mo = this.getMatrixObject(varName);
        long dim1 = -1L;
        long dim2 = -1L;
        DMLRuntimeException e = null;
        try {
            dim1 = ExecutionContext.validateDimensions(mo.getNumRows(), numRows);
        }
        catch (DMLRuntimeException e1) {
            e = e1;
        }
        try {
            dim2 = ExecutionContext.validateDimensions(mo.getNumColumns(), numCols);
        }
        catch (DMLRuntimeException e1) {
            e = e1;
        }
        if (e != null) {
            throw new DMLRuntimeException("Incorrect dimensions given to allocateGPUMatrixObject: [" + numRows + "," + numCols + "], [" + mo.getNumRows() + "," + mo.getNumColumns() + "]", e);
        }
        if (dim1 != mo.getNumRows() || dim2 != mo.getNumColumns()) {
            mo.getMatrixCharacteristics().setDimension(dim1, dim2);
        }
        if (mo.getGPUObject(this.getGPUContext(0)) == null) {
            GPUObject newGObj = this.getGPUContext(0).createGPUObject(mo);
            mo.setGPUObject(this.getGPUContext(0), newGObj);
        }
        mo.getGPUObject(this.getGPUContext(0)).addWriteLock();
        return mo;
    }

    public MatrixObject getMatrixInputForGPUInstruction(String varName, String opcode) {
        GPUContext gCtx = this.getGPUContext(0);
        MatrixObject mo = this.getMatrixObject(varName);
        if (mo == null) {
            throw new DMLRuntimeException("No matrix object available for variable:" + varName);
        }
        if (mo.getGPUObject(gCtx) == null) {
            GPUObject newGObj = gCtx.createGPUObject(mo);
            mo.setGPUObject(gCtx, newGObj);
        }
        mo.getGPUObject(gCtx).acquireDeviceRead(opcode);
        return mo;
    }

    public void releaseMatrixInput(String varName) {
        this.getMatrixObject(varName).release();
    }

    public void releaseMatrixInput(String varName, String opcode) {
        long t1 = opcode != null && DMLScript.STATISTICS && DMLScript.FINEGRAINED_STATISTICS ? System.nanoTime() : 0L;
        this.releaseMatrixInput(varName);
        if (opcode != null && DMLScript.STATISTICS && DMLScript.FINEGRAINED_STATISTICS) {
            long t2 = System.nanoTime();
            GPUStatistics.maintainCPMiscTimes(opcode, "rlsi", t2 - t1);
        }
    }

    public void releaseMatrixInputForGPUInstruction(String varName) {
        MatrixObject mo = this.getMatrixObject(varName);
        mo.getGPUObject(this.getGPUContext(0)).releaseInput();
    }

    public FrameBlock getFrameInput(String varName) {
        FrameObject fo = this.getFrameObject(varName);
        return (FrameBlock)fo.acquireRead();
    }

    public void releaseFrameInput(String varName) {
        FrameObject fo = this.getFrameObject(varName);
        fo.release();
    }

    public ScalarObject getScalarInput(CPOperand input) {
        return this.getScalarInput(input.getName(), input.getValueType(), input.isLiteral());
    }

    public ScalarObject getScalarInput(String name, Expression.ValueType vt, boolean isLiteral) {
        if (isLiteral) {
            return ScalarObjectFactory.createScalarObject(vt, name);
        }
        Data obj = this.getVariable(name);
        if (obj == null) {
            throw new DMLRuntimeException("Unknown variable: " + name);
        }
        return (ScalarObject)obj;
    }

    public void setScalarOutput(String varName, ScalarObject so) {
        this.setVariable(varName, so);
    }

    public ListObject getListObject(String name) {
        Data dat = this.getVariable(name);
        if (dat == null) {
            throw new DMLRuntimeException("Variable '" + name + "' does not exist in the symbol table.");
        }
        if (!(dat instanceof ListObject)) {
            throw new DMLRuntimeException("Variable '" + name + "' is not a list.");
        }
        return (ListObject)dat;
    }

    public void releaseMatrixOutputForGPUInstruction(String varName) {
        MatrixObject mo = this.getMatrixObject(varName);
        if (mo.getGPUObject(this.getGPUContext(0)) == null || !mo.getGPUObject(this.getGPUContext(0)).isAllocated()) {
            throw new DMLRuntimeException("No output is allocated on GPU");
        }
        this.setMetaData(varName, new MetaDataFormat(mo.getMatrixCharacteristics(), OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo));
        mo.getGPUObject(this.getGPUContext(0)).releaseOutput();
    }

    public void setMatrixOutput(String varName, MatrixBlock outputData) {
        MatrixObject mo = this.getMatrixObject(varName);
        mo.acquireModify(outputData);
        mo.release();
        this.setVariable(varName, mo);
    }

    public void setMatrixOutput(String varName, MatrixBlock outputData, String opcode) {
        this.setMatrixOutput(varName, outputData);
    }

    public void setMatrixOutput(String varName, MatrixBlock outputData, MatrixObject.UpdateType flag) {
        if (flag.isInPlace()) {
            MatrixObject mo = this.getMatrixObject(varName);
            mo.setUpdateType(flag);
        }
        this.setMatrixOutput(varName, outputData);
    }

    public void setMatrixOutput(String varName, MatrixBlock outputData, MatrixObject.UpdateType flag, String opcode) {
        this.setMatrixOutput(varName, outputData, flag);
    }

    public void setFrameOutput(String varName, FrameBlock outputData) {
        FrameObject fo = this.getFrameObject(varName);
        fo.acquireModify(outputData);
        fo.release();
        this.setVariable(varName, fo);
    }

    public List<MatrixBlock> getMatrixInputs(CPOperand[] inputs) {
        return Arrays.stream(inputs).filter(in -> in.isMatrix()).map(in -> this.getMatrixInput(in.getName())).collect(Collectors.toList());
    }

    public List<ScalarObject> getScalarInputs(CPOperand[] inputs) {
        return Arrays.stream(inputs).filter(in -> in.isScalar()).map(in -> this.getScalarInput((CPOperand)in)).collect(Collectors.toList());
    }

    public void releaseMatrixInputs(CPOperand[] inputs) {
        Arrays.stream(inputs).filter(in -> in.isMatrix()).forEach(in -> this.releaseMatrixInput(in.getName()));
    }

    public boolean[] pinVariables(List<String> varList) {
        int i;
        int nlist = 0;
        int nlistItems = 0;
        for (int i2 = 0; i2 < varList.size(); ++i2) {
            Data dat = this._variables.get(varList.get(i2));
            if (!(dat instanceof ListObject)) continue;
            nlistItems += ((ListObject)dat).getNumCacheableData();
            ++nlist;
        }
        boolean[] varsState = new boolean[varList.size() - nlist + nlistItems];
        int pos = 0;
        for (i = 0; i < varList.size(); ++i) {
            Data dat = this._variables.get(varList.get(i));
            if (dat instanceof CacheableData) {
                varsState[pos++] = ((CacheableData)dat).isCleanupEnabled();
                continue;
            }
            if (!(dat instanceof ListObject)) continue;
            for (Data dat2 : ((ListObject)dat).getData()) {
                if (!(dat2 instanceof CacheableData)) continue;
                varsState[pos++] = ((CacheableData)dat2).isCleanupEnabled();
            }
        }
        for (i = 0; i < varList.size(); ++i) {
            Data dat = this._variables.get(varList.get(i));
            if (dat instanceof CacheableData) {
                ((CacheableData)dat).enableCleanup(false);
                continue;
            }
            if (!(dat instanceof ListObject)) continue;
            for (Data dat2 : ((ListObject)dat).getData()) {
                if (!(dat2 instanceof CacheableData)) continue;
                ((CacheableData)dat2).enableCleanup(false);
            }
        }
        return varsState;
    }

    public void unpinVariables(List<String> varList, boolean[] varsState) {
        int pos = 0;
        for (int i = 0; i < varList.size(); ++i) {
            Data dat = this._variables.get(varList.get(i));
            if (dat instanceof CacheableData) {
                ((CacheableData)dat).enableCleanup(varsState[pos++]);
                continue;
            }
            if (!(dat instanceof ListObject)) continue;
            for (Data dat2 : ((ListObject)dat).getData()) {
                if (!(dat2 instanceof CacheableData)) continue;
                ((CacheableData)dat2).enableCleanup(varsState[pos++]);
            }
        }
    }

    public ArrayList<String> getVarList() {
        return new ArrayList<String>(this._variables.keySet());
    }

    public ArrayList<String> getVarListPartitioned() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String var : this._variables.keySet()) {
            Data dat = this._variables.get(var);
            if (!(dat instanceof MatrixObject) || !((MatrixObject)dat).isPartitioned()) continue;
            ret.add(var);
        }
        return ret;
    }

    public final void cleanupDataObject(Data dat) {
        if (dat == null) {
            return;
        }
        if (dat instanceof CacheableData) {
            this.cleanupCacheableData((CacheableData)dat);
        } else if (dat instanceof ListObject) {
            for (Data dat2 : ((ListObject)dat).getData()) {
                if (!(dat2 instanceof CacheableData)) continue;
                this.cleanupCacheableData((CacheableData)dat2);
            }
        }
    }

    public void cleanupCacheableData(CacheableData<?> mo) {
        boolean fileExists;
        if (DMLScript.JMLC_MEM_STATISTICS) {
            Statistics.removeCPMemObject(System.identityHashCode(mo));
        }
        boolean bl = fileExists = mo.isHDFSFileExists() && mo.getFileName() != null;
        if (!CacheableData.isCachingActive() && !fileExists) {
            return;
        }
        try {
            if (mo.isCleanupEnabled() && !this.getVariables().hasReferences(mo)) {
                mo.clearData();
                if (fileExists) {
                    MapReduceTool.deleteFileIfExistOnHDFS(mo.getFileName());
                    MapReduceTool.deleteFileIfExistOnHDFS(mo.getFileName() + ".mtd");
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public void initDebugProgramCounters() {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            this._dbState.pc = new DMLProgramCounter(".defaultNS", "main", 0, 0);
            this._dbState.prevPC = new DMLProgramCounter(".defaultNS", "main", 0, 0);
        }
    }

    public void updateDebugState(int index) {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            this._dbState.getPC().setProgramBlockNumber(index);
        }
    }

    public void updateDebugState(Instruction currInst) {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            this._dbState.nextCommand = false;
            this._dbState.getPC().setInstID(currInst.getInstID());
            this._dbState.getPC().setLineNumber(currInst.getLineNum());
            this.suspendIfAskedInDebugMode(currInst);
        }
    }

    public void clearDebugProgramCounters() {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            this._dbState.pc = null;
        }
    }

    public void handleDebugException(Exception ex) {
        this._dbState.getDMLStackTrace(ex);
        this._dbState.suspend = true;
    }

    public void handleDebugFunctionEntry(FunctionCallCPInstruction funCallInst) {
        this._dbState.pushFrame(this.getVariables(), this._dbState.getPC());
        this._dbState.pc = new DMLProgramCounter(funCallInst.getNamespace(), funCallInst.getFunctionName(), 0, 0);
    }

    public void handleDebugFunctionExit(FunctionCallCPInstruction funCallInst) {
        DMLFrame fr = this._dbState.popFrame();
        this._dbState.pc = fr.getPC();
    }

    public DebugState getDebugState() {
        return this._dbState;
    }

    private void suspendIfAskedInDebugMode(Instruction currInst) {
        if (!DMLScript.ENABLE_DEBUG_MODE) {
            System.err.println("ERROR: The function suspendIfAskedInDebugMode should not be called in non-debug mode.");
        }
        if (!this._dbState.suspend && this._dbState.dbCommand != null) {
            if (this._dbState.dbCommand.equalsIgnoreCase("step_instruction")) {
                System.out.format("Step instruction reached at %s.\n", this._dbState.getPC().toString());
                this._dbState.suspend = true;
            } else if (this._dbState.dbCommand.equalsIgnoreCase("step_line") && this._dbState.prevPC.getLineNumber() != currInst.getLineNum() && this._dbState.prevPC.getLineNumber() != 0) {
                System.out.format("Step reached at %s.\n", this._dbState.getPC().toStringWithoutInstructionID());
                this._dbState.suspend = true;
            } else if (this._dbState.dbCommand.equalsIgnoreCase("step return") && currInst instanceof FunctionCallCPInstruction) {
                FunctionCallCPInstruction funCallInst = (FunctionCallCPInstruction)currInst;
                if (this._dbState.dbCommandArg == null || funCallInst.getFunctionName().equalsIgnoreCase(this._dbState.dbCommandArg)) {
                    System.out.format("Step return reached at %s.\n", this._dbState.getPC().toStringWithoutInstructionID());
                    this._dbState.suspend = true;
                }
            }
        }
        if (this._dbState.suspend) {
            this._dbState.dbCommand = null;
            this._dbState.dbCommandArg = null;
            if (currInst.getLineNum() != 0) {
                this._dbState.printDMLSourceLine(currInst.getLineNum());
            }
            this._dbState.setVariables(this.getVariables());
            this._dbState.nextCommand = true;
            Thread.currentThread().suspend();
            this._dbState.nextCommand = false;
        }
        this._dbState.suspend = false;
        this._dbState.prevPC.setFunctionName(this._dbState.getPC().getFunctionName());
        this._dbState.prevPC.setProgramBlockNumber(this._dbState.getPC().getProgramBlockNumber());
        this._dbState.prevPC.setLineNumber(currInst.getLineNum());
    }
}

