/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;

public class L2_reg
extends Script {
    public L2_reg() {
        String string = "scripts/nn/layers/l2_reg.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public double forward(Object object, Object object2) {
        String string = "source('scripts/nn/layers/l2_reg.dml') as mlcontextns;reg_loss = mlcontextns::forward(X, lambda);";
        Script script = new Script(string);
        script.in("X", object).in("lambda", object2).out("reg_loss");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("reg_loss");
        return d;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, double lambda)\n    return (double reg_loss) {\n  /*\n   * Computes the forward pass for an L2 regularization function.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *  - lambda: Regularization strength.\n   *      A typical value is 0.01.\n   *\n   * Outputs:\n   *  - reg_loss: Total regularization loss.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, double lambda)\n    return (double reg_loss) {\n  /*\n   * Computes the forward pass for an L2 regularization function.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *  - lambda: Regularization strength.\n   *      A typical value is 0.01.\n   *\n   * Outputs:\n   *  - reg_loss: Total regularization loss.\n   */\n  reg_loss = 0.5 * lambda * sum(X^2)\n}\n";
        return string;
    }

    public Matrix backward(Object object, Object object2) {
        String string = "source('scripts/nn/layers/l2_reg.dml') as mlcontextns;dX = mlcontextns::backward(X, lambda);";
        Script script = new Script(string);
        script.in("X", object).in("lambda", object2).out("dX");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        return matrix;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] X, double lambda)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for an L2 regularization function.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *  - lambda: Regularization strength.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of same shape as `X`.\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] X, double lambda)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for an L2 regularization function.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *  - lambda: Regularization strength.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of same shape as `X`.\n   */\n  dX = lambda * X\n}\n";
        return string;
    }
}

