/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.sample;

import org.apache.sysds.runtime.compress.estim.sample.FrequencyCount;
import org.apache.sysds.runtime.compress.utils.Bitmap;

public class ShlosserEstimator {
    public static int get(Bitmap ubm, int nRows, int sampleSize) {
        double q = (double)sampleSize / (double)nRows;
        double oneMinusQ = 1.0 - q;
        int numVals = ubm.getNumValues();
        int[] freqCounts = FrequencyCount.get(ubm);
        double numerSum = 0.0;
        double denomSum = 0.0;
        int iPlusOne = 1;
        int i = 0;
        while (i < freqCounts.length) {
            numerSum += Math.pow(oneMinusQ, iPlusOne) * (double)freqCounts[i];
            denomSum += (double)iPlusOne * q * Math.pow(oneMinusQ, i) * (double)freqCounts[i];
            ++i;
            ++iPlusOne;
        }
        int estimate = (int)Math.round((double)numVals + (double)freqCounts[0] * numerSum / denomSum);
        return estimate < 1 ? 1 : estimate;
    }
}

