/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.sample;

import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.sysds.runtime.compress.estim.sample.ShlosserEstimator;
import org.apache.sysds.runtime.compress.estim.sample.SmoothedJackknifeEstimator;
import org.apache.sysds.runtime.compress.utils.Bitmap;

public class ShlosserJackknifeEstimator {
    private static final double SHLOSSER_JACKKNIFE_ALPHA = 0.975;

    private static int shlosserJackknifeEstimator(Bitmap ubm, int nRows, int sampleSize) {
        int numVals = ubm.getNumValues();
        CriticalValue cv = ShlosserJackknifeEstimator.computeCriticalValue(sampleSize);
        double nBar = (double)sampleSize / (double)numVals;
        double u = 0.0;
        for (int i = 0; i < numVals; ++i) {
            u += Math.pow((double)ubm.getNumOffsets(i) - nBar, 2.0);
        }
        u /= nBar;
        if (sampleSize != cv.usedSampleSize) {
            ShlosserJackknifeEstimator.computeCriticalValue(sampleSize);
        }
        if (u < cv.uniformityCriticalValue) {
            return SmoothedJackknifeEstimator.get(ubm, nRows, sampleSize);
        }
        return ShlosserEstimator.get(ubm, nRows, sampleSize);
    }

    private static CriticalValue computeCriticalValue(int sampleSize) {
        ChiSquaredDistribution chiSqr = new ChiSquaredDistribution((double)(sampleSize - 1));
        return new CriticalValue(chiSqr.inverseCumulativeProbability(0.975), sampleSize);
    }

    private static class CriticalValue {
        public final double uniformityCriticalValue;
        public final int usedSampleSize;

        public CriticalValue(double cv, int size) {
            this.uniformityCriticalValue = cv;
            this.usedSampleSize = size;
        }
    }
}

