/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.gpu.BuiltinBinaryGPUInstruction;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysds.runtime.matrix.data.LibMatrixCuDNN;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.utils.GPUStatistics;

public class ScalarMatrixBuiltinGPUInstruction
extends BuiltinBinaryGPUInstruction {
    protected ScalarMatrixBuiltinGPUInstruction(Operator op, CPOperand input1, CPOperand input2, CPOperand output, String opcode, String istr, int _arity) {
        super(op, input1, input2, output, opcode, istr, _arity);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary;
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        String opcode = this.getOpcode();
        CPOperand mat = this.input1.getDataType() == Types.DataType.MATRIX ? this.input1 : this.input2;
        CPOperand scalar = this.input1.getDataType() == Types.DataType.MATRIX ? this.input2 : this.input1;
        MatrixObject in1 = this.getMatrixInputForGPUInstruction(ec, mat.getName());
        ScalarObject constant = ec.getScalarInput(scalar);
        if (opcode.equals("max")) {
            ec.setMetaData(this.output.getName(), in1.getNumRows(), in1.getNumColumns());
            double constVal = constant.getDoubleValue();
            if (constVal == 0.0) {
                LibMatrixCuDNN.relu(ec, ec.getGPUContext(0), this.getExtendedOpcode(), in1, this.output.getName());
            } else {
                LibMatrixCUDA.matrixScalarOp(ec, ec.getGPUContext(0), this.getExtendedOpcode(), in1, this.output.getName(), false, InstructionUtils.parseScalarBinaryOperator(opcode, false, constVal));
            }
        } else if (opcode.equals("min")) {
            ec.setMetaData(this.output.getName(), in1.getNumRows(), in1.getNumColumns());
            double constVal = constant.getDoubleValue();
            LibMatrixCUDA.matrixScalarOp(ec, ec.getGPUContext(0), this.getExtendedOpcode(), in1, this.output.getName(), false, InstructionUtils.parseScalarBinaryOperator(opcode, false, constVal));
        } else {
            throw new DMLRuntimeException("Unsupported GPU operator:" + opcode);
        }
        ec.releaseMatrixInputForGPUInstruction(mat.getName());
        ec.releaseMatrixOutputForGPUInstruction(this.output.getName());
    }
}

