/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.Comparator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.DataGenCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ListIndexingCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MatrixIndexingCPInstruction;
import org.apache.sysds.runtime.lineage.LineageCacheEntry;

public class LineageCacheConfig {
    private static final String[] OPCODES = new String[]{"tsmm", "ba+*", "*", "/", "+", "||", "nrow", "ncol", "round", "exp", "log", "rightIndex", "leftIndex", "groupedagg", "r'", "solve", "spoof", "uamean", "max", "min", "ifelse", "-", "sqrt", ">", "uak+", "<=", "^", "uamax", "uark+", "uacmean", "eigen", "ctableexpand", "replace", "^2", "uack+", "tak+*", "uacsqk+", "uark+", "n+", "uarimax", "qsort", "qpick"};
    private static String[] REUSE_OPCODES = new String[0];
    private static ReuseCacheType _cacheType = null;
    private static CachedItemHead _itemH = null;
    private static CachedItemTail _itemT = null;
    private static boolean _compilerAssistedRW = false;
    private static boolean _allowSpill = false;
    public static final double MIN_SPILL_TIME_ESTIMATE = 100.0;
    public static final double MIN_SPILL_DATA = 20.0;
    public static double FSREAD_DENSE = 200.0;
    public static double FSREAD_SPARSE = 100.0;
    public static double FSWRITE_DENSE = 150.0;
    public static double FSWRITE_SPARSE = 75.0;
    private static LineageCachePolicy _cachepolicy = null;
    protected static double[] WEIGHTS = new double[]{0.0, 1.0};
    protected static Comparator<LineageCacheEntry> LineageCacheComparator = (e1, e2) -> e1.score == e2.score ? Long.compare(e1._key.getId(), e2._key.getId()) : (e1.score < e2.score ? -1 : 1);

    public static void setReusableOpcodes(String ... ops) {
        REUSE_OPCODES = ops;
    }

    public static void resetReusableOpcodes() {
        REUSE_OPCODES = OPCODES;
    }

    public static boolean isReusable(Instruction inst, ExecutionContext ec) {
        boolean insttype = inst instanceof ComputationCPInstruction && !(inst instanceof ListIndexingCPInstruction);
        boolean rightop = ArrayUtils.contains((Object[])REUSE_OPCODES, (Object)inst.getOpcode()) || inst.getOpcode().equals("append") && LineageCacheConfig.isVectorAppend(inst, ec) || inst instanceof DataGenCPInstruction && ((DataGenCPInstruction)inst).isMatrixCall();
        boolean updateInplace = inst instanceof MatrixIndexingCPInstruction && ec.getMatrixObject(((ComputationCPInstruction)inst).input1).getUpdateType().isInPlace();
        return insttype && rightop && !updateInplace;
    }

    private static boolean isVectorAppend(Instruction inst, ExecutionContext ec) {
        ComputationCPInstruction cpinst = (ComputationCPInstruction)inst;
        if (!cpinst.input1.isMatrix() || !cpinst.input2.isMatrix()) {
            return false;
        }
        long c1 = ec.getMatrixObject(cpinst.input1).getNumColumns();
        long c2 = ec.getMatrixObject(cpinst.input2).getNumColumns();
        return c1 == 1L || c2 == 1L;
    }

    public static void setConfigTsmmCbind(ReuseCacheType ct) {
        _cacheType = ct;
        _itemH = CachedItemHead.TSMM;
        _itemT = CachedItemTail.CBIND;
    }

    public static void setConfig(ReuseCacheType ct) {
        _cacheType = ct;
    }

    public static void setConfig(ReuseCacheType ct, CachedItemHead ith, CachedItemTail itt) {
        _cacheType = ct;
        _itemH = ith;
        _itemT = itt;
    }

    public static void setCompAssRW(boolean comp) {
        _compilerAssistedRW = comp;
    }

    public static void shutdownReuse() {
        DMLScript.LINEAGE = false;
        DMLScript.LINEAGE_REUSE = ReuseCacheType.NONE;
    }

    public static void restartReuse(ReuseCacheType rop) {
        DMLScript.LINEAGE = true;
        DMLScript.LINEAGE_REUSE = rop;
    }

    public static ReuseCacheType getCacheType() {
        return _cacheType;
    }

    public static boolean isMultiLevelReuse() {
        return !ReuseCacheType.isNone() && _cacheType.isMultilevelReuse();
    }

    public static CachedItemHead getCachedItemHead() {
        return _itemH;
    }

    public static CachedItemTail getCachedItemTail() {
        return _itemT;
    }

    public static boolean getCompAssRW() {
        return _compilerAssistedRW;
    }

    public static void setCachePolicy(LineageCachePolicy policy) {
        switch (policy) {
            case LRU: {
                LineageCacheConfig.WEIGHTS[0] = 0.0;
                LineageCacheConfig.WEIGHTS[1] = 1.0;
                break;
            }
            case COSTNSIZE: {
                LineageCacheConfig.WEIGHTS[0] = 1.0;
                LineageCacheConfig.WEIGHTS[1] = 0.0;
                break;
            }
            case HYBRID: {
                LineageCacheConfig.WEIGHTS[0] = 1.0;
                LineageCacheConfig.WEIGHTS[1] = 0.0033;
            }
        }
        _cachepolicy = policy;
    }

    public static LineageCachePolicy getCachePolicy() {
        return _cachepolicy;
    }

    public static boolean isTimeBased() {
        return WEIGHTS[1] > 0.0;
    }

    public static void setSpill(boolean toSpill) {
        _allowSpill = toSpill;
    }

    public static boolean isSetSpill() {
        return _allowSpill;
    }

    static {
        REUSE_OPCODES = OPCODES;
        LineageCacheConfig.setSpill(true);
        LineageCacheConfig.setCachePolicy(LineageCachePolicy.HYBRID);
        LineageCacheConfig.setCompAssRW(true);
    }

    public static enum LineageCachePolicy {
        LRU,
        COSTNSIZE,
        HYBRID;

    }

    protected static enum LineageCacheStatus {
        EMPTY,
        CACHED,
        SPILLED,
        RELOADED,
        PINNED,
        TOSPILL,
        TODELETE;


        public boolean canEvict() {
            return this == CACHED || this == RELOADED;
        }
    }

    private static enum CachedItemTail {
        CBIND,
        RBIND,
        INDEX,
        ALL;

    }

    private static enum CachedItemHead {
        TSMM,
        ALL;

    }

    public static enum ReuseCacheType {
        REUSE_FULL,
        REUSE_PARTIAL,
        REUSE_MULTILEVEL,
        REUSE_HYBRID,
        NONE;


        public boolean isFullReuse() {
            return this == REUSE_FULL || this == REUSE_MULTILEVEL || this == REUSE_HYBRID;
        }

        public boolean isPartialReuse() {
            return this == REUSE_PARTIAL || this == REUSE_HYBRID;
        }

        public boolean isMultilevelReuse() {
            return this == REUSE_MULTILEVEL || this == REUSE_HYBRID;
        }

        public static boolean isNone() {
            return DMLScript.LINEAGE_REUSE == null || DMLScript.LINEAGE_REUSE == NONE;
        }
    }
}

