/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;

public class CompressionStatistics {
    private ArrayList<Double> timePhases = new ArrayList();
    public double ratio;
    public long originalSize;
    public long estimatedSizeColGroups;
    public long estimatedSizeCols;
    public long size;
    private Map<ColGroup.CompressionType, int[]> colGroupCounts;

    public void setNextTimePhase(double time) {
        this.timePhases.add(time);
    }

    public double getLastTimePhase() {
        return this.timePhases.get(this.timePhases.size() - 1);
    }

    public void setColGroupsCounts(List<ColGroup> colGroups) {
        HashMap<ColGroup.CompressionType, int[]> ret = new HashMap<ColGroup.CompressionType, int[]>();
        for (ColGroup c : colGroups) {
            int[] values;
            ColGroup.CompressionType ct = c.getCompType();
            int colCount = c.getNumCols();
            if (ret.containsKey((Object)ct)) {
                values = ret.get((Object)ct);
                values[0] = values[0] + 1;
                values[1] = values[1] + colCount;
            } else {
                values = new int[]{1, colCount};
            }
            ret.put(ct, values);
        }
        this.colGroupCounts = ret;
    }

    public Map<ColGroup.CompressionType, int[]> getColGroups() {
        return this.colGroupCounts;
    }

    public ArrayList<Double> getTimeArrayList() {
        return this.timePhases;
    }

    public String getGroupsTypesString() {
        StringBuilder sb = new StringBuilder();
        for (ColGroup.CompressionType ctKey : this.colGroupCounts.keySet()) {
            sb.append((Object)((Object)ctKey) + ":" + this.colGroupCounts.get((Object)ctKey)[0] + " ");
        }
        return sb.toString();
    }

    public String getGroupsSizesString() {
        StringBuilder sb = new StringBuilder();
        for (ColGroup.CompressionType ctKey : this.colGroupCounts.keySet()) {
            sb.append((Object)((Object)ctKey) + ":" + this.colGroupCounts.get((Object)ctKey)[1] + " ");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Compression Statistics:\n");
        sb.append("\t" + this.getGroupsTypesString() + "\n");
        sb.append("\t" + this.getGroupsSizesString() + "\n");
        return sb.toString();
    }
}

