/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.UnaryFEDInstruction;

public class ReorgFEDInstruction
extends UnaryFEDInstruction {
    public ReorgFEDInstruction(CPOperand in1, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.Reorg, null, in1, out, opcode, istr);
    }

    public static ReorgFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("r'")) {
            InstructionUtils.checkNumFields(str, 2, 3);
            CPOperand in = new CPOperand(parts[1]);
            CPOperand out = new CPOperand(parts[2]);
            return new ReorgFEDInstruction(in, out, opcode, str);
        }
        throw new DMLRuntimeException("ReorgFEDInstruction: unsupported opcode: " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject mo1 = ec.getMatrixObject(this.input1);
        if (!mo1.isFederated()) {
            throw new DMLRuntimeException("Federated Reorg: Federated input expected, but invoked w/ " + mo1.isFederated());
        }
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1}, new long[]{mo1.getFedMapping().getID()});
        mo1.getFedMapping().execute(this.getTID(), true, fr1);
        MatrixObject out = ec.getMatrixObject(this.output);
        out.getDataCharacteristics().set(mo1.getNumColumns(), mo1.getNumRows(), (int)mo1.getBlocksize(), mo1.getNnz());
        out.setFedMapping(mo1.getFedMapping().copyWithNewID(fr1.getID()).transpose());
    }
}

