/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.meta;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysds.api.jmlc.Connection;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.transform.TfUtils;
import org.apache.sysds.runtime.transform.decode.DecoderRecode;
import org.apache.sysds.runtime.util.CollectionUtils;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class TfMetaUtils {
    public static boolean isIDSpec(String spec) {
        try {
            JSONObject jSpec = new JSONObject(spec);
            return TfMetaUtils.isIDSpec(jSpec);
        }
        catch (JSONException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static boolean isIDSpec(JSONObject spec) throws JSONException {
        return spec.containsKey("ids") && spec.getBoolean("ids");
    }

    public static boolean containsOmitSpec(String spec, String[] colnames) {
        return TfMetaUtils.parseJsonIDList(spec, colnames, TfUtils.TfMethod.OMIT.toString()).length > 0;
    }

    public static int[] parseJsonIDList(String spec, String[] colnames, String group) {
        try {
            JSONObject jSpec = new JSONObject(spec);
            return TfMetaUtils.parseJsonIDList(jSpec, colnames, group);
        }
        catch (JSONException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static int[] parseJsonIDList(JSONObject spec, String[] colnames, String group) throws JSONException {
        return TfMetaUtils.parseJsonIDList(spec, colnames, group, -1, -1);
    }

    public static int[] parseJsonIDList(JSONObject spec, String[] colnames, String group, int minCol, int maxCol) throws JSONException {
        boolean ids;
        ArrayList<Integer> colList = new ArrayList<Integer>();
        int[] arr = new int[]{};
        boolean bl = ids = spec.containsKey("ids") && spec.getBoolean("ids");
        if (spec.containsKey(group)) {
            JSONArray attrs = null;
            if (spec.get(group) instanceof JSONObject) {
                attrs = (JSONArray)((JSONObject)spec.get(group)).get("attributes");
                ids = true;
            } else {
                attrs = (JSONArray)spec.get(group);
            }
            for (int i2 = 0; i2 < attrs.length(); ++i2) {
                int ix;
                if (ids) {
                    ix = UtilFunctions.toInt(attrs.get(i2));
                    if (maxCol != -1 && ix >= maxCol) {
                        ix = -1;
                    }
                    if (minCol != -1 && ix >= 0) {
                        ix -= minCol - 1;
                    }
                } else {
                    ix = ArrayUtils.indexOf((Object[])colnames, attrs.get(i2)) + 1;
                }
                if (ix > 0) {
                    colList.add(ix);
                    continue;
                }
                if (minCol != -1 || maxCol != -1) continue;
                throw new RuntimeException("Specified column '" + attrs.get(i2) + "' does not exist.");
            }
            arr = colList.stream().mapToInt(i -> i).sorted().toArray();
        }
        return arr;
    }

    public static int[] parseJsonObjectIDList(JSONObject spec, String[] colnames, String group, int minCol, int maxCol) throws JSONException {
        boolean ids;
        ArrayList<Integer> colList = new ArrayList<Integer>();
        int[] arr = new int[]{};
        boolean bl = ids = spec.containsKey("ids") && spec.getBoolean("ids");
        if (spec.containsKey(group) && spec.get(group) instanceof JSONArray) {
            JSONArray colspecs = (JSONArray)spec.get(group);
            for (Object o : colspecs) {
                int ix;
                JSONObject colspec = (JSONObject)o;
                if (ids) {
                    ix = colspec.getInt("id");
                    if (maxCol != -1 && ix >= maxCol) {
                        ix = -1;
                    }
                    if (minCol != -1 && ix >= 0) {
                        ix -= minCol - 1;
                    }
                } else {
                    ix = ArrayUtils.indexOf((Object[])colnames, (Object)colspec.get("name")) + 1;
                }
                if (ix > 0) {
                    colList.add(ix);
                    continue;
                }
                if (minCol != -1 || maxCol != -1) continue;
                throw new RuntimeException("Specified column '" + colspec.get(ids ? "id" : "name") + "' does not exist.");
            }
            arr = colList.stream().mapToInt(i -> i).sorted().toArray();
        }
        return arr;
    }

    public static FrameBlock readTransformMetaDataFromFile(String spec, String metapath, String colDelim) throws IOException {
        String colnamesStr = HDFSTool.readStringFromHDFSFile(metapath + File.separator + "column.names");
        String[] colnames = IOUtilFunctions.split(colnamesStr.trim(), colDelim);
        HashMap<String, String> meta = new HashMap<String, String>();
        HashMap<String, String> mvmeta = new HashMap<String, String>();
        int rows = 0;
        for (int j = 0; j < colnames.length; ++j) {
            String name3;
            String name2;
            String colName = colnames[j];
            String name = metapath + File.separator + "Recode" + File.separator + colName;
            if (HDFSTool.existsFileOnHDFS(name + ".map")) {
                meta.put(colName, HDFSTool.readStringFromHDFSFile(name + ".map"));
                String ndistinct = HDFSTool.readStringFromHDFSFile(name + ".ndistinct");
                rows = Math.max(rows, Integer.parseInt(ndistinct));
            }
            if (HDFSTool.existsFileOnHDFS((name2 = metapath + File.separator + "Bin" + File.separator + colName) + ".bin")) {
                String binmap = HDFSTool.readStringFromHDFSFile(name2 + ".bin");
                meta.put(colName, binmap);
                rows = Math.max(rows, Integer.parseInt(binmap.split(",")[4]));
            }
            if (!HDFSTool.existsFileOnHDFS((name3 = metapath + File.separator + "Impute" + File.separator + colName) + ".impute")) continue;
            String mvmap = HDFSTool.readStringFromHDFSFile(name3 + ".impute");
            mvmeta.put(colName, mvmap);
        }
        List<Integer> recodeIDs = TfMetaUtils.parseRecodeColIDs(spec, colnames);
        List<Integer> binIDs = TfMetaUtils.parseBinningColIDs(spec, colnames, -1, -1);
        return TfMetaUtils.convertToTransformMetaDataFrame(rows, colnames, recodeIDs, binIDs, meta, mvmeta);
    }

    public static FrameBlock readTransformMetaDataFromPath(String spec, String metapath, String colDelim) throws IOException {
        String colnamesStr = TfMetaUtils.getStringFromResource(metapath + "/" + "column.names");
        String[] colnames = IOUtilFunctions.split(colnamesStr.trim(), colDelim);
        HashMap<String, String> meta = new HashMap<String, String>();
        HashMap<String, String> mvmeta = new HashMap<String, String>();
        int rows = 0;
        for (int j = 0; j < colnames.length; ++j) {
            String name3;
            String map3;
            String name2;
            String map2;
            String colName = colnames[j];
            String name = metapath + "/Recode/" + colName;
            String map = TfMetaUtils.getStringFromResource(name + ".map");
            if (map != null) {
                meta.put(colName, map);
                String ndistinct = TfMetaUtils.getStringFromResource(name + ".ndistinct");
                rows = Math.max(rows, Integer.parseInt(ndistinct));
            }
            if ((map2 = TfMetaUtils.getStringFromResource((name2 = metapath + "/Bin/" + colName) + ".bin")) != null) {
                meta.put(colName, map2);
                rows = Math.max(rows, Integer.parseInt(map2.split(",")[4]));
            }
            if ((map3 = TfMetaUtils.getStringFromResource((name3 = metapath + File.separator + "Impute" + File.separator + colName) + ".impute")) == null) continue;
            mvmeta.put(colName, map3);
        }
        List<Integer> recodeIDs = TfMetaUtils.parseRecodeColIDs(spec, colnames);
        List<Integer> binIDs = TfMetaUtils.parseBinningColIDs(spec, colnames, -1, -1);
        return TfMetaUtils.convertToTransformMetaDataFrame(rows, colnames, recodeIDs, binIDs, meta, mvmeta);
    }

    private static FrameBlock convertToTransformMetaDataFrame(int rows, String[] colnames, List<Integer> rcIDs, List<Integer> binIDs, HashMap<String, String> meta, HashMap<String, String> mvmeta) throws IOException {
        String map;
        String name;
        Types.ValueType[] schema = UtilFunctions.nCopies(colnames.length, Types.ValueType.STRING);
        FrameBlock ret = new FrameBlock(schema, colnames);
        ret.ensureAllocatedColumns(rows);
        for (Integer n : rcIDs) {
            String line;
            name = colnames[n - 1];
            map = meta.get(name);
            if (map == null) {
                throw new IOException("Recode map for column '" + name + "' (id=" + n + ") not existing.");
            }
            ByteArrayInputStream is = new ByteArrayInputStream(map.getBytes("UTF-8"));
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            Pair<String, String> pair = new Pair<String, String>();
            int rpos = 0;
            while ((line = br.readLine()) != null) {
                DecoderRecode.parseRecodeMapEntry(line, pair);
                String tmp = pair.getKey() + "\u00b7" + pair.getValue();
                ret.set(rpos++, n - 1, tmp);
            }
            ret.getColumnMetadata(n - 1).setNumDistinct(rpos);
        }
        for (Integer n : binIDs) {
            name = colnames[n - 1];
            map = meta.get(name);
            if (map == null) {
                throw new IOException("Binning map for column '" + name + "' (id=" + n + ") not existing.");
            }
            String[] fields = map.split(",");
            double min = UtilFunctions.parseToDouble(fields[1], UtilFunctions.defaultNaString);
            double binwidth = UtilFunctions.parseToDouble(fields[3], UtilFunctions.defaultNaString);
            int nbins = UtilFunctions.parseToInt(fields[4]);
            for (int i = 0; i < nbins; ++i) {
                String lbound = String.valueOf(min + (double)i * binwidth);
                String ubound = String.valueOf(min + (double)(i + 1) * binwidth);
                ret.set(i, n - 1, lbound + "\u00b7" + ubound);
            }
            ret.getColumnMetadata(n - 1).setNumDistinct(nbins);
        }
        for (Map.Entry entry : mvmeta.entrySet()) {
            int colID = ArrayUtils.indexOf((Object[])colnames, entry.getKey()) + 1;
            String mvVal = ((String)entry.getValue()).split(",")[1];
            ret.getColumnMetadata(colID - 1).setMvValue(mvVal);
        }
        return ret;
    }

    private static List<Integer> parseRecodeColIDs(String spec, String[] colnames) throws IOException {
        if (spec == null) {
            throw new IOException("Missing transform specification.");
        }
        List<Integer> specRecodeIDs = null;
        try {
            JSONObject jSpec = new JSONObject(spec);
            List<Integer> rcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.RECODE.toString())));
            List<Integer> dcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.DUMMYCODE.toString())));
            specRecodeIDs = CollectionUtils.unionDistinct(rcIDs, dcIDs);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return specRecodeIDs;
    }

    public static List<Integer> parseBinningColIDs(String spec, String[] colnames, int minCol, int maxCol) throws IOException {
        try {
            JSONObject jSpec = new JSONObject(spec);
            return TfMetaUtils.parseBinningColIDs(jSpec, colnames, minCol, maxCol);
        }
        catch (JSONException ex) {
            throw new IOException(ex);
        }
    }

    public static List<Integer> parseBinningColIDs(JSONObject jSpec, String[] colnames, int minCol, int maxCol) throws IOException {
        try {
            String binKey = TfUtils.TfMethod.BIN.toString();
            if (jSpec.containsKey(binKey) && jSpec.get(binKey) instanceof JSONArray) {
                return Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonObjectIDList(jSpec, colnames, binKey, minCol, maxCol)));
            }
            return Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, binKey)));
        }
        catch (JSONException ex) {
            throw new IOException(ex);
        }
    }

    private static String getStringFromResource(String path) throws IOException {
        try (InputStream is = Connection.class.getResourceAsStream(path);){
            String string = IOUtilFunctions.toString(is);
            return string;
        }
    }
}

