/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.EnumSet;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.PlanningCoCoder;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.estim.sample.SampleEstimatorFactory;

public class CompressionSettingsBuilder {
    private double samplingRatio;
    private boolean allowSharedDictionary = false;
    private String transposeInput;
    private boolean skipList = true;
    private int seed = -1;
    private boolean lossy = false;
    private EnumSet<AColGroup.CompressionType> validCompressions;
    private boolean sortValuesByLength = true;
    private PlanningCoCoder.PartitionerType columnPartitioner;
    private int maxColGroupCoCode = 10000;
    private double coCodePercentage = 0.01;
    private int minimumSampleSize = 2000;
    private SampleEstimatorFactory.EstimationType estimationType = SampleEstimatorFactory.EstimationType.HassAndStokes;
    private static final double defaultSampleRate = 0.01;

    public CompressionSettingsBuilder() {
        String[] validCompressionsString;
        DMLConfig conf = ConfigurationManager.getDMLConfig();
        this.lossy = conf.getBooleanValue("sysds.compressed.lossy");
        this.validCompressions = EnumSet.of(AColGroup.CompressionType.UNCOMPRESSED, AColGroup.CompressionType.CONST);
        for (String comp : validCompressionsString = conf.getTextValue("sysds.compressed.valid.compressions").split(",")) {
            this.validCompressions.add(AColGroup.CompressionType.valueOf(comp));
        }
        this.samplingRatio = conf.getDoubleValue("sysds.compressed.sampling.ratio");
        if (Double.isNaN(this.samplingRatio)) {
            this.samplingRatio = 0.01;
        }
        this.columnPartitioner = PlanningCoCoder.PartitionerType.valueOf(conf.getTextValue("sysds.compressed.cocode"));
        this.transposeInput = conf.getTextValue("sysds.compressed.transpose");
    }

    public CompressionSettingsBuilder copySettings(CompressionSettings that) {
        this.samplingRatio = that.samplingRatio;
        this.allowSharedDictionary = that.allowSharedDictionary;
        this.transposeInput = that.transposeInput;
        this.skipList = that.skipList;
        this.seed = that.seed;
        this.lossy = that.lossy;
        this.validCompressions = EnumSet.copyOf(that.validCompressions);
        this.sortValuesByLength = that.sortValuesByLength;
        this.columnPartitioner = that.columnPartitioner;
        this.maxColGroupCoCode = that.maxColGroupCoCode;
        this.coCodePercentage = that.coCodePercentage;
        this.minimumSampleSize = that.minimumSampleSize;
        return this;
    }

    public CompressionSettingsBuilder setLossy(boolean lossy) {
        this.lossy = lossy;
        return this;
    }

    public CompressionSettingsBuilder setSamplingRatio(double samplingRatio) {
        this.samplingRatio = samplingRatio;
        return this;
    }

    public CompressionSettingsBuilder setSortValuesByLength(boolean sortValuesByLength) {
        this.sortValuesByLength = sortValuesByLength;
        return this;
    }

    public CompressionSettingsBuilder setAllowSharedDictionary(boolean allowSharedDictionary) {
        this.allowSharedDictionary = allowSharedDictionary;
        return this;
    }

    public CompressionSettingsBuilder setTransposeInput(String transposeInput) {
        switch (transposeInput) {
            case "auto": 
            case "true": 
            case "false": {
                this.transposeInput = transposeInput;
                break;
            }
            default: {
                throw new DMLCompressionException("Invalid transpose technique");
            }
        }
        return this;
    }

    public CompressionSettingsBuilder setSkipList(boolean skipList) {
        this.skipList = skipList;
        return this;
    }

    public CompressionSettingsBuilder setSeed(int seed) {
        this.seed = seed;
        return this;
    }

    public CompressionSettingsBuilder setValidCompressions(EnumSet<AColGroup.CompressionType> validCompressions) {
        if (!validCompressions.contains((Object)AColGroup.CompressionType.UNCOMPRESSED)) {
            validCompressions.add(AColGroup.CompressionType.UNCOMPRESSED);
        }
        if (!validCompressions.contains((Object)AColGroup.CompressionType.CONST)) {
            validCompressions.add(AColGroup.CompressionType.CONST);
        }
        this.validCompressions = validCompressions;
        return this;
    }

    public CompressionSettingsBuilder addValidCompression(AColGroup.CompressionType cp) {
        this.validCompressions.add(cp);
        return this;
    }

    public CompressionSettingsBuilder clearValidCompression() {
        this.validCompressions = EnumSet.of(AColGroup.CompressionType.UNCOMPRESSED);
        return this;
    }

    public CompressionSettingsBuilder setColumnPartitioner(PlanningCoCoder.PartitionerType columnPartitioner) {
        this.columnPartitioner = columnPartitioner;
        return this;
    }

    public CompressionSettingsBuilder setMaxColGroupCoCode(int maxColGroupCoCode) {
        this.maxColGroupCoCode = maxColGroupCoCode;
        return this;
    }

    public CompressionSettingsBuilder setCoCodePercentage(double coCodePercentage) {
        this.coCodePercentage = coCodePercentage;
        return this;
    }

    public CompressionSettingsBuilder setMinimumSampleSize(int minimumSampleSize) {
        this.minimumSampleSize = minimumSampleSize;
        return this;
    }

    public CompressionSettingsBuilder setEstimationType(SampleEstimatorFactory.EstimationType estimationType) {
        this.estimationType = estimationType;
        return this;
    }

    public CompressionSettings create() {
        return new CompressionSettings(this.samplingRatio, this.allowSharedDictionary, this.transposeInput, this.skipList, this.seed, this.lossy, this.validCompressions, this.sortValuesByLength, this.columnPartitioner, this.maxColGroupCoCode, this.coCodePercentage, this.minimumSampleSize, this.estimationType);
    }
}

