/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.ComputationFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;

public abstract class UnaryFEDInstruction
extends ComputationFEDInstruction {
    protected UnaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        this(type, op, in, null, null, out, opcode, instr);
    }

    protected UnaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in, CPOperand out, String opcode, String instr, FEDInstruction.FederatedOutput fedOut) {
        this(type, op, in, null, null, out, opcode, instr, fedOut);
    }

    protected UnaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String instr) {
        this(type, op, in1, in2, null, out, opcode, instr);
    }

    protected UnaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String instr, FEDInstruction.FederatedOutput fedOut) {
        this(type, op, in1, in2, null, out, opcode, instr, fedOut);
    }

    protected UnaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String instr) {
        this(type, op, in1, in2, in3, out, opcode, instr, FEDInstruction.FederatedOutput.NONE);
    }

    protected UnaryFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String instr, FEDInstruction.FederatedOutput fedOut) {
        super(type, op, in1, in2, in3, out, opcode, instr, fedOut);
    }

    static String parseUnaryInstruction(String instr, CPOperand in, CPOperand out) {
        int num = InstructionUtils.checkNumFields(instr, 2, 3);
        if (num == 2) {
            return UnaryFEDInstruction.parse(instr, in, null, null, out);
        }
        return UnaryFEDInstruction.parseWithFedOutFlag(instr, in, out);
    }

    static String parseUnaryInstruction(String instr, CPOperand in1, CPOperand in2, CPOperand out) {
        InstructionUtils.checkNumFields(instr, 3);
        return UnaryFEDInstruction.parse(instr, in1, in2, null, out);
    }

    static String parseUnaryInstruction(String instr, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out) {
        InstructionUtils.checkNumFields(instr, 4);
        return UnaryFEDInstruction.parse(instr, in1, in2, in3, out);
    }

    private static String parse(String instr, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(instr);
        String opcode = parts[0];
        out.split(parts[parts.length - 1]);
        switch (parts.length) {
            case 3: {
                in1.split(parts[1]);
                in2 = null;
                in3 = null;
                break;
            }
            case 4: {
                in1.split(parts[1]);
                in2.split(parts[2]);
                in3 = null;
                break;
            }
            case 5: {
                in1.split(parts[1]);
                in2.split(parts[2]);
                in3.split(parts[3]);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unexpected number of operands in the instruction: " + instr);
            }
        }
        return opcode;
    }

    private static String parseWithFedOutFlag(String instr, CPOperand in1, CPOperand out) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(instr);
        String opcode = parts[0];
        in1.split(parts[1]);
        out.split(parts[parts.length - 2]);
        return opcode;
    }
}

