/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.data.DenseBlockFP64;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class MatrixBlockDictionary
extends ADictionary {
    private MatrixBlock _data;

    public MatrixBlockDictionary(MatrixBlock data) {
        this._data = data;
    }

    public MatrixBlock getMatrixBlock() {
        return this._data;
    }

    @Override
    public double[] getValues() {
        throw new DMLCompressionException("Get Values should not be called when you have a MatrixBlockDictionary");
    }

    @Override
    public double getValue(int i) {
        int nCol = this._data.getNumColumns();
        int row = i / nCol;
        if (row > this._data.getNumRows()) {
            return 0.0;
        }
        int col = i % nCol;
        return this._data.quickGetValue(row, col);
    }

    @Override
    public long getInMemorySize() {
        return 8L + this._data.estimateSizeInMemory();
    }

    public static long getInMemorySize(int numberValues, int numberColumns, double sparsity) {
        return 8L + MatrixBlock.estimateSizeInMemory(numberValues, numberColumns, sparsity);
    }

    @Override
    public double aggregate(double init, Builtin fn) {
        if (fn.getBuiltinCode() == Builtin.BuiltinCode.MAX) {
            return fn.execute(init, this._data.max());
        }
        if (fn.getBuiltinCode() == Builtin.BuiltinCode.MIN) {
            return fn.execute(init, this._data.min());
        }
        throw new NotImplementedException();
    }

    @Override
    public double[] aggregateTuples(Builtin fn, int nCol) {
        double[] ret = new double[this._data.getNumRows()];
        if (this._data.isEmpty()) {
            return ret;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (!sb.isEmpty(i)) {
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    ret[i] = avals[apos];
                    for (int j = apos + 1; j < alen; ++j) {
                        ret[i] = fn.execute(ret[i], avals[j]);
                    }
                    if (sb.size(i) >= this._data.getNumColumns()) continue;
                    ret[i] = fn.execute(ret[i], 0.0);
                    continue;
                }
                ret[i] = fn.execute(ret[i], 0.0);
            }
        } else {
            if (nCol == 1) {
                return this._data.getDenseBlockValues();
            }
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                ret[k] = values[off++];
                for (int j = 1; j < this._data.getNumColumns(); ++j) {
                    ret[k] = fn.execute(ret[k], values[off++]);
                }
            }
        }
        return ret;
    }

    @Override
    public void aggregateCols(double[] c, Builtin fn, int[] colIndexes) {
        if (this._data.isEmpty()) {
            for (int j = 0; j < colIndexes.length; ++j) {
                int idx = colIndexes[j];
                c[idx] = fn.execute(c[idx], 0.0);
            }
        } else if (this._data.isInSparseFormat()) {
            MatrixBlock t = LibMatrixReorg.transposeInPlace(this._data, 1);
            if (!t.isInSparseFormat()) {
                throw new NotImplementedException();
            }
            SparseBlock sbt = t.getSparseBlock();
            for (int i = 0; i < this._data.getNumColumns(); ++i) {
                int idx = colIndexes[i];
                if (!sbt.isEmpty(i)) {
                    int apos = sbt.pos(i);
                    int alen = sbt.size(i) + apos;
                    double[] avals = sbt.values(i);
                    for (int j = apos; j < alen; ++j) {
                        c[idx] = fn.execute(c[idx], avals[j]);
                    }
                    if (alen == this._data.getNumRows()) continue;
                    c[idx] = fn.execute(c[idx], 0.0);
                    continue;
                }
                c[idx] = fn.execute(c[idx], 0.0);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    int idx = colIndexes[j];
                    c[idx] = fn.execute(c[idx], values[off++]);
                }
            }
        }
    }

    @Override
    public ADictionary apply(ScalarOperator op) {
        MatrixBlock res = this._data.scalarOperations(op, new MatrixBlock());
        return new MatrixBlockDictionary(res);
    }

    @Override
    public ADictionary applyScalarOp(ScalarOperator op, double newVal, int numCols) {
        MatrixBlock res = this._data.scalarOperations(op, new MatrixBlock());
        int lastRow = res.getNumRows();
        MatrixBlock res2 = new MatrixBlock(lastRow + 1, res.getNumColumns(), true);
        if (res.isEmpty()) {
            for (int i = 0; i < numCols; ++i) {
                res2.appendValue(lastRow, i, newVal);
            }
            return new MatrixBlockDictionary(res2);
        }
        res.append(new MatrixBlock(1, numCols, newVal), res2, false);
        return new MatrixBlockDictionary(res2);
    }

    @Override
    public ADictionary applyBinaryRowOpLeft(BinaryOperator op, double[] v, boolean sparseSafe, int[] colIndexes) {
        MatrixBlock rowVector = new MatrixBlock(1, colIndexes.length, false);
        for (int i = 0; i < colIndexes.length; ++i) {
            rowVector.quickSetValue(0, i, v[colIndexes[i]]);
        }
        MatrixBlock res = new MatrixBlock();
        if (sparseSafe) {
            rowVector.binaryOperations(op, this._data, res);
        } else {
            MatrixBlock tmp = new MatrixBlock();
            tmp = this._data.append(new MatrixBlock(1, this._data.getNumColumns(), 0L), tmp, false);
            rowVector.binaryOperations(op, tmp, res);
        }
        return new MatrixBlockDictionary(res);
    }

    @Override
    public ADictionary applyBinaryRowOpRight(BinaryOperator op, double[] v, boolean sparseSafe, int[] colIndexes) {
        MatrixBlock rowVector = new MatrixBlock(1, colIndexes.length, false);
        for (int i = 0; i < colIndexes.length; ++i) {
            rowVector.quickSetValue(0, i, v[colIndexes[i]]);
        }
        MatrixBlock res = new MatrixBlock();
        if (sparseSafe) {
            this._data.binaryOperations(op, rowVector, res);
        } else {
            if (!this._data.isInSparseFormat()) {
                LOG.warn((Object)"Inefficient binary row op allocating Matrix multiple times");
            }
            MatrixBlock tmp = new MatrixBlock();
            tmp = this._data.append(new MatrixBlock(1, this._data.getNumColumns(), 0L), tmp, false);
            tmp.binaryOperations(op, rowVector, res);
        }
        return new MatrixBlockDictionary(res);
    }

    @Override
    public ADictionary clone() {
        MatrixBlock ret = new MatrixBlock();
        ret.copy(this._data);
        return new MatrixBlockDictionary(ret);
    }

    @Override
    public ADictionary cloneAndExtend(int len) {
        throw new NotImplementedException();
    }

    @Override
    public boolean isLossy() {
        return false;
    }

    @Override
    public int getNumberOfValues(int ncol) {
        return this._data.getNumRows();
    }

    @Override
    public double[] sumAllRowsToDouble(boolean square, int nrColumns) {
        double[] ret = new double[this._data.getNumRows()];
        if (this._data.isEmpty()) {
            return ret;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = i;
                    ret[n] = ret[n] + (square ? avals[j] * avals[j] : avals[j]);
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = k;
                    ret[n] = ret[n] + (square ? v * v : v);
                }
            }
        }
        return ret;
    }

    @Override
    public double sumRow(int k, boolean square, int nrColumns) {
        throw new NotImplementedException();
    }

    @Override
    public double[] colSum(int[] counts, int nCol) {
        if (this._data.isEmpty()) {
            return null;
        }
        double[] ret = new double[nCol];
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = aix[j];
                    ret[n] = ret[n] + (double)count * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                int countK = counts[k];
                int j = 0;
                while (j < this._data.getNumColumns()) {
                    double v = values[off++];
                    int n = j++;
                    ret[n] = ret[n] + v * (double)countK;
                }
            }
        }
        return ret;
    }

    @Override
    public void colSum(double[] c, int[] counts, int[] colIndexes, boolean square) {
        if (this._data.isEmpty()) {
            return;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = colIndexes[aix[j]];
                    c[n] = c[n] + (square ? (double)count * avals[j] * avals[j] : (double)count * avals[j]);
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = colIndexes[j];
                    c[n] = c[n] + (square ? v * v * (double)countK : v * (double)countK);
                }
            }
        }
    }

    @Override
    public double sum(int[] counts, int ncol) {
        double tmpSum = 0.0;
        if (this._data.isEmpty()) {
            return tmpSum;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    tmpSum += (double)count * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    tmpSum += v * (double)countK;
                }
            }
        }
        return tmpSum;
    }

    @Override
    public double sumsq(int[] counts, int ncol) {
        double tmpSum = 0.0;
        if (this._data.isEmpty()) {
            return tmpSum;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    tmpSum += (double)count * avals[j] * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    tmpSum += v * v * (double)countK;
                }
            }
        }
        return tmpSum;
    }

    @Override
    public String getString(int colIndexes) {
        return this._data.toString();
    }

    @Override
    public void addMaxAndMin(double[] ret, int[] colIndexes) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary sliceOutColumnRange(int idxStart, int idxEnd, int previousNumberOfColumns) {
        MatrixBlock retBlock = this._data.slice(0, this._data.getNumRows() - 1, idxStart, idxEnd - 1);
        return new MatrixBlockDictionary(retBlock);
    }

    @Override
    public ADictionary reExpandColumns(int max) {
        throw new NotImplementedException();
    }

    @Override
    public boolean containsValue(double pattern) {
        return this._data.containsValue(pattern);
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        if (this._data.isEmpty()) {
            return 0L;
        }
        long nnz = 0L;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                nnz += (long)(sb.size(i) * counts[i]);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                int countThisTuple = 0;
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v;
                    if ((v = values[off++]) == 0.0) continue;
                    ++countThisTuple;
                }
                nnz += (long)(countThisTuple * counts[i]);
            }
        }
        return nnz;
    }

    @Override
    public void addToEntry(Dictionary d, int fr, int to, int nCol) {
        double[] v = d.getValues();
        if (this._data.isEmpty()) {
            return;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            if (sb.isEmpty(fr)) {
                return;
            }
            int apos = sb.pos(fr);
            int alen = sb.size(fr) + apos;
            int[] aix = sb.indexes(fr);
            double[] avals = sb.values(fr);
            int offsetTo = nCol * to;
            for (int j = apos; j < alen; ++j) {
                int n = offsetTo + aix[j];
                v[n] = v[n] + avals[j];
            }
        } else {
            int sf = nCol * fr;
            int ef = sf + nCol;
            double[] thisV = this._data.getDenseBlockValues();
            int j = nCol * to;
            for (int i = sf; i < ef; ++i) {
                int n = j++;
                v[n] = v[n] + thisV[i];
            }
        }
    }

    @Override
    public double[] getTuple(int index, int nCol) {
        if (this._data.isEmpty() || index >= this._data.getNumRows()) {
            return null;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            if (sb.isEmpty(index)) {
                return null;
            }
            double[] tuple = new double[nCol];
            int apos = sb.pos(index);
            int alen = sb.size(index) + apos;
            int[] aix = sb.indexes(index);
            double[] avals = sb.values(index);
            for (int j = apos; j < alen; ++j) {
                tuple[aix[j]] = avals[j];
            }
            return tuple;
        }
        double[] tuple = new double[nCol];
        double[] values = this._data.getDenseBlockValues();
        int offset = index * nCol;
        int i = 0;
        while (i < nCol) {
            tuple[i] = values[offset];
            ++i;
            ++offset;
        }
        return tuple;
    }

    @Override
    public ADictionary subtractTuple(double[] tuple) {
        DenseBlockFP64 b = new DenseBlockFP64(new int[]{1, tuple.length}, tuple);
        MatrixBlock rowVector = new MatrixBlock(1, tuple.length, b);
        MatrixBlock res = new MatrixBlock(this._data.getNumColumns(), this._data.getNumRows(), this._data.isInSparseFormat());
        this._data.binaryOperations(new BinaryOperator(Minus.getMinusFnObject()), rowVector, res);
        return new MatrixBlockDictionary(res);
    }

    @Override
    public MatrixBlockDictionary getAsMatrixBlockDictionary(int nCol) {
        return this;
    }

    public String toString() {
        return "MatrixBlock Dictionary :" + this._data.toString();
    }

    @Override
    public ADictionary scaleTuples(int[] scaling, int nCol) {
        if (this._data.isEmpty()) {
            throw new NotImplementedException("could return null here? or empty DictionaryMatrixBlock...");
        }
        if (this._data.isInSparseFormat()) {
            MatrixBlock retBlock = new MatrixBlock(this._data.getNumRows(), this._data.getNumColumns(), true);
            retBlock.allocateSparseRowsBlock(true);
            SparseBlock sbRet = retBlock.getSparseBlock();
            SparseBlock sbThis = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sbThis.isEmpty(i)) continue;
                sbRet.set(i, sbThis.get(i), true);
                int count = scaling[i];
                int apos = sbRet.pos(i);
                int alen = sbRet.size(i) + apos;
                double[] avals = sbRet.values(i);
                for (int j = apos; j < alen; ++j) {
                    avals[j] = (double)count * avals[j];
                }
            }
            retBlock.setNonZeros(this._data.getNonZeros());
            return new MatrixBlockDictionary(retBlock);
        }
        double[] _values = this._data.getDenseBlockValues();
        double[] scaledValues = new double[_values.length];
        int off = 0;
        for (int tuple = 0; tuple < _values.length / nCol; ++tuple) {
            int scale = scaling[tuple];
            for (int v = 0; v < nCol; ++v) {
                scaledValues[off] = _values[off] * (double)scale;
                ++off;
            }
        }
        DenseBlockFP64 db = new DenseBlockFP64(new int[]{this._data.getNumRows(), this._data.getNumColumns()}, scaledValues);
        MatrixBlock retBlock = new MatrixBlock(this._data.getNumRows(), this._data.getNumColumns(), db);
        retBlock.setNonZeros(this._data.getNonZeros());
        return new MatrixBlockDictionary(retBlock);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(DictionaryFactory.Type.MATRIX_BLOCK_DICT.ordinal());
        this._data.write(out);
    }

    public static MatrixBlockDictionary read(DataInput in) throws IOException {
        MatrixBlock ret = new MatrixBlock();
        ret.readFields(in);
        return new MatrixBlockDictionary(ret);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 1L + this._data.getExactSizeOnDisk();
    }

    @Override
    public void preaggValuesFromDense(int numVals, int[] colIndexes, int[] aggregateColumns, double[] b, double[] ret, int cut) {
        if (this._data.isEmpty()) {
            return;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int off = aggregateColumns.length * i;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                int[] aix = sb.indexes(i);
                for (int j = apos; j < alen; ++j) {
                    int idb = colIndexes[aix[j]] * cut;
                    double v = avals[j];
                    for (int h = 0; h < aggregateColumns.length; ++h) {
                        int n = off + h;
                        ret[n] = ret[n] + v * b[idb + aggregateColumns[h]];
                    }
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int k = 0;
            int off = 0;
            while (k < numVals * colIndexes.length) {
                for (int h = 0; h < colIndexes.length; ++h) {
                    int idb = colIndexes[h] * cut;
                    double v = values[k + h];
                    if (v == 0.0) continue;
                    for (int i = 0; i < aggregateColumns.length; ++i) {
                        int n = off + i;
                        ret[n] = ret[n] + v * b[idb + aggregateColumns[i]];
                    }
                }
                k += colIndexes.length;
                off += aggregateColumns.length;
            }
        }
    }

    @Override
    public ADictionary replace(double pattern, double replace, int nCol, boolean safe) {
        if (!safe && replace == 0.0) {
            throw new NotImplementedException("Not implemented Replacement of 0");
        }
        MatrixBlock ret = this._data.replaceOperations(new MatrixBlock(), pattern, replace);
        return new MatrixBlockDictionary(ret);
    }
}

