/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class MMTSJCPInstruction
extends UnaryCPInstruction {
    private final MMTSJ.MMTSJType _type;
    private final int _numThreads;

    private MMTSJCPInstruction(Operator op, CPOperand in1, MMTSJ.MMTSJType type, CPOperand out, int k, String opcode, String istr) {
        super(CPInstruction.CPType.MMTSJ, op, in1, out, opcode, istr);
        this._type = type;
        this._numThreads = k;
    }

    public static MMTSJCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 4);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        MMTSJ.MMTSJType titype = MMTSJ.MMTSJType.valueOf(parts[3]);
        int k = Integer.parseInt(parts[4]);
        if (!opcode.equalsIgnoreCase("tsmm")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an MMTSJCPInstruction: " + str);
        }
        return new MMTSJCPInstruction(new Operator(true), in1, titype, out, k, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName());
        MatrixBlock ret = matBlock1.transposeSelfMatrixMultOperations(new MatrixBlock(), this._type, this._numThreads);
        ec.setMatrixOutput(this.output.getName(), ret);
        ec.releaseMatrixInput(this.input1.getName());
    }

    public MMTSJ.MMTSJType getMMTSJType() {
        return this._type;
    }
}

